import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import GalleryGrid from ".";

export async function GalleryGridLoader(props) {
  let reducedResults = props;

  const { items } = reducedResults;

  for (let i = 0; i < items.length; i++) {
    await Promise.all(
      items[i].items.map(async (item) => {
        const { url } = item.image;
        const base64ImageUrl = await getBase64ImageUrl(url);
        return {
          ...item,
          image: {
            ...item.image,
            base64: base64ImageUrl,
          },
        };
      })
    ).then((result) => {
      reducedResults.items[i].items = result;
    });
  }

  return <GalleryGrid {...reducedResults} />;
}
