"use client";

import {
  Grid,
  GridItem,
  Box,
  Flex,
  Text,
  useDisclosure,
} from "@chakra-ui/react";
import {
  KtContainer,
  AppSection,
  KtHeading,
  AppImage,
  AnimationWrapper,
  AppGalleryLightBox,
} from "@/app/_components";

import { appTextFontSize } from "@/app/_components/_styles";
import { isObjectEmpty } from "@/app/_utils";
import { useGallery } from "@/app/_components/AppGalleryLightBox/_utils/useGallery";

import { LightBoxContextProvider } from "@/app/_context";
import { scaleVariant } from "@/app/_utils/animationVariants";

import { CommonFilter } from "../Filter";

function GalleryItem({
  category,
  idx,
  onOpen,
  image: { url,turl, alt, base64 },
  caption = "",
}) {
  const { handleChangeGalleryItem } = useGallery();

  return (
    <Box
      h={{
        base: "250",
        sm: "250",
        md: "300",
      }}
      pos="relative"
      borderRadius="10px"
      overflow="hidden"
      cursor="pointer"
    >
      <AnimationWrapper
        w="full"
        borderRadius="10px"
        h="full"
        variants={scaleVariant}
        transition="0.3s linear"
        whileHover
        animateRoot
        overlay
        onClick={() => {
          handleChangeGalleryItem(idx);
          onOpen();
        }}
      >
        <AppImage
          src={turl}
          alt={alt}
          title={alt}
          blurDataURL={base64}
          fill
          sizes="30vw"
          style={{
            width: "100%",
            height: "100%",
            borderRadius: "var(--kerala-tourism-radii-md)",
            objectFit: "cover",
          }}
        />
      </AnimationWrapper>
      {caption && (
        <Box
          pos="absolute"
          bg="whiteAlpha.400"
          zIndex={2}
          bottom={0}
          p={4}
          w="full"
        >
          <Text
            fontSize={appTextFontSize}
            overflow="hidden"
            color="white"
            sx={{
              display: "-webkit-box",
              WebkitLineClamp: "1",
              WebkitBoxOrient: "vertical",
            }}
            onClick={() => {
              handleChangeGalleryItem(idx);
              onOpen();
            }}
          >
            {caption}
          </Text>
        </Box>
      )}
    </Box>
  );
}

export default function Gallery({
  block: { category },
  intro: { heading, description },
  items,
  filters = {},
}) {
  const { isOpen, onOpen, onClose } = useDisclosure();

  return (
    <LightBoxContextProvider data={{ gallery: { [category]: items } }}>
      <AppSection>
        <KtContainer>
          {!isObjectEmpty(filters) && <CommonFilter filters={filters} />}
          <Grid
            templateColumns={{
              base: "repeat(1, 1fr)",
              sm: "repeat(2, 1fr)",
              lg: "repeat(3, 1fr)",
            }}
            gap={6}
          >
            <GridItem colSpan={{ base: 1, sm: 2, lg: 1 }}>
              <Flex
                direction="column"
                gap={6}
                align="center"
                justify="center"
                h="full"
              >
                <KtHeading as="h6">{heading}</KtHeading>
                <Text fontSize={appTextFontSize}>{description}</Text>
              </Flex>
            </GridItem>
            {items.map(({ id, ...restProps }, idx) => (
              <GalleryItem
                key={id}
                category={category}
                idx={idx}
                onOpen={onOpen}
                {...restProps}
              />
            ))}
          </Grid>
        </KtContainer>
      </AppSection>

      {/* Gallery Light Box */}
      <AppGalleryLightBox isOpen={isOpen} onClose={onClose} />
    </LightBoxContextProvider>
  );
}
