import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import Gallery from ".";

export async function GalleryLoader(props) {
  let reducedResults = props;

  const items = props.items;

  const blurImagePromise = items.map(({ image: { url } }) =>
    getBase64ImageUrl(url)
  );

  const imageWithBlurDataUrls = await Promise.all(blurImagePromise);

  for (let i = 0; i < items.length; i++) {
    items[i].image = {
      ...items[i].image,
      base64: imageWithBlurDataUrls[i],
    };
  }

  reducedResults = {
    ...reducedResults,
    items,
  };

  return <Gallery {...reducedResults} />;
}
