"use client";

import { Box, useMediaQuery } from "@chakra-ui/react";

import { AppSearchInput, KtContainer } from "@/app/_components";

import DesktopFilter from "./_includes/DesktopFilter";
import MobileFilter from "./_includes/MobileFilter";

function FilterWrapper({ children }) {
  return (
    <Box
      pb={8}
      sx={{
        "@media screen and (max-width: 990px)": {
          ".filter__desktop": {
            display: "none",
          },
          ".filter__mobile": {
            display: "block",
          },
        },
        "@media screen and (min-width: 990px)": {
          ".filter__desktop": {
            display: "block",
          },
          ".filter__mobile": {
            display: "none",
          },
        },
      }}
    >
      {children}
    </Box>
  );
}

export function CommonFilter({ filters }) {
  const [isSmallDevice] = useMediaQuery(["(max-width: 991px)"], {
    ssr: true,
    fallback: true,
  });

  const [isDesktopAndSmallScreen] = useMediaQuery(["(min-width: 990px)"], {
    ssr: true,
    fallback: true,
  });

  return (
    <KtContainer pt={8}>
      <FilterWrapper>
        {isDesktopAndSmallScreen && (
          <Box className="filter__desktop">
            <DesktopFilter {...filters} />
          </Box>
        )}

        {isSmallDevice && (
          <Box className="filter__mobile">
            <MobileFilter {...filters} />
          </Box>
        )}
      </FilterWrapper>
    </KtContainer>
  );
}

export function ListFilter({
  filters,
  search = false,
  handlePrimaryFilterChange,
  handlePrimaryFilterClear,
  selectedValues,
}) {

//console.log("selectedValues in filter index 1:",selectedValues);

  const [isSmallDevice] = useMediaQuery(["(max-width: 991px)"], {
    ssr: true,
    fallback: true,
  });

  const [isDesktopAndSmallScreen] = useMediaQuery(["(min-width: 990px)"], {
    ssr: true,
    fallback: true,
  });
 
  return (
    <>
      {search && <AppSearchInput btnTitle="Go" serachInputAction={() => {}} />}
      <FilterWrapper>
        {isDesktopAndSmallScreen && (
          <Box className="filter__desktop">
            <DesktopFilter
              {...filters}
              handlePrimaryFilterChange={handlePrimaryFilterChange}
              handlePrimaryFilterClear={handlePrimaryFilterClear}
              selectedValues={selectedValues}
            />
          </Box>
        )}

        {isSmallDevice && (
          <Box className="filter__mobile">
            <MobileFilter
              {...filters}
              handlePrimaryFilterChange={handlePrimaryFilterChange}              
              handlePrimaryFilterClear={handlePrimaryFilterClear}
              selectedValues={selectedValues}
            />
          </Box>
        )}
      </FilterWrapper>
    </>
  );
}
