import { Box, Text, Button, useDisclosure } from "@chakra-ui/react";
import { AppModal } from "@/app/_components";

import { FilterWrapper, LinkList } from "../_common";
import { FilterIcon, FilterComponent } from "../_components";

import { appTextFontSize } from "@/app/_components/_styles";

import { isObjectEmpty } from "@/app/_utils";

export default function MobileFilter({
  primary_filters,
  secondary_filter = [],
  handlePrimaryFilterChange,
  handlePrimaryFilterClear,
  selectedValues,
}) {
  const { isOpen, onOpen, onClose } = useDisclosure();

  return (
    <>
      <FilterWrapper justify="space-between">
      {primary_filters && primary_filters.length > 0 && (
        <FilterIcon type="mobile" onClick={onOpen} />
        )}

        {/* Rendering Links If the the secondry filter has link key */}
        {secondary_filter?.links && (
          <FilterWrapper gap={4}>
            <LinkList links={secondary_filter.links} />
          </FilterWrapper>
        )}
      </FilterWrapper>

      {/* Rendering Application Modal */}
      <AppModal
        isOpen={isOpen}
        onClose={onClose}
        renderHeader={() => (
          <Text
            as="p"
            fontWeight="semibold"
            color="black"
            fontSize={appTextFontSize}
          >
            Filter By
          </Text>
        )}
        closeBtnProps={{
          bg: "orangePeel.900",
          borderRadius: "full",
          color: "white",
        }}
        hasHeader
      >
        <FilterWrapper
          direction="column"
          gap={6}
          sx={{
            ".react-datepicker-wrapper": {
              width: "full",
            },
          }}
        >
          {/* Rendering Primary Filters */}
          {primary_filters.map(({ _id, ...restProps }) => (
            <Box key={_id}>
              <FilterComponent
                {...restProps}
                isMobile={true}
                primary_filters={primary_filters}
                handlePrimaryFilterChange={handlePrimaryFilterChange}
                selectedValuesVariable={selectedValues}
              />
            </Box>
          ))}

          {/* Rendering Secondary Filters */}
          {secondary_filter.length > 0 && (
            <>
              {secondary_filter.map(({ _id, ...restProps }) => (
                <Box key={_id}>
                  <FilterComponent
                    {...restProps}
                    isMobile={true}
                    secondary_filter={secondary_filter}
                    selectedValuesVariable={selectedValues}
                  />
                </Box>
              ))}
            </>
          )}

          {/* Submit And Cancel Button */}
          
          <FilterWrapper justify="flex-end" align="center" pb={6} gap={2}>
            {primary_filters && primary_filters.length > 0 && !isObjectEmpty(selectedValues) && (
              <Button
                variant="solid"
                onClick={() => {
                  handlePrimaryFilterClear(primary_filters);
                }}
              >
                Clear
              </Button>
            )}
          </FilterWrapper>
        

        </FilterWrapper>
      </AppModal>
    </>
  );
}


// import { Box, Text, Button, useDisclosure } from "@chakra-ui/react";
// import { AppModal } from "@/app/_components";
// import { FilterWrapper, LinkList } from "../_common";
// import { FilterIcon, FilterComponent } from "../_components";
// import { appTextFontSize } from "@/app/_components/_styles";

// export default function MobileFilter({
//   primary_filters,
//   secondary_filter = [],
//   handlePrimaryFilterChange,
//   handlePrimaryFilterClear,
//   selectedValues,
// }) {
//   const { isOpen, onOpen, onClose } = useDisclosure();

//   return (
//     <>
//       {(primary_filters && primary_filters.length > 0) || (secondary_filter && secondary_filter.length > 0) && (
//         <>
//           <FilterWrapper justify="space-between">
//             <FilterIcon type="mobile" onClick={onOpen} />
//             {/* Rendering Links If the secondary filter has link key */}
//             {secondary_filter?.links && (
//               <FilterWrapper gap={4}>
//                 <LinkList links={secondary_filter.links} />
//               </FilterWrapper>
//             )}
//           </FilterWrapper>

//           {/* Rendering Application Modal */}
//           <AppModal
//             isOpen={isOpen}
//             onClose={onClose}
//             renderHeader={() => (
//               <Text
//                 as="p"
//                 fontWeight="semibold"
//                 color="black"
//                 fontSize={appTextFontSize}
//               >
//                 Filter By
//               </Text>
//             )}
//             closeBtnProps={{
//               bg: "orangePeel.900",
//               borderRadius: "full",
//               color: "white",
//             }}
//             hasHeader
//           >
//             <FilterWrapper
//               direction="column"
//               gap={6}
//               sx={{
//                 ".react-datepicker-wrapper": {
//                   width: "full",
//                 },
//               }}
//             >
//               {/* Rendering Primary Filters */}
//               {primary_filters.map(({ _id, ...restProps }) => (
//                 <Box key={_id}>
//                   <FilterComponent
//                     {...restProps}
//                     isMobile={true}
//                     primary_filters={primary_filters}
//                     handlePrimaryFilterChange={handlePrimaryFilterChange}
//                     selectedValuesVariable={selectedValues}
//                   />
//                 </Box>
//               ))}

//               {/* Rendering Secondary Filters */}
//               {secondary_filter.length > 0 && (
//                 <>
//                   {secondary_filter.map(({ _id, ...restProps }) => (
//                     <Box key={_id}>
//                       <FilterComponent
//                         {...restProps}
//                         isMobile={true}
//                         secondary_filter={secondary_filter}
//                         selectedValuesVariable={selectedValues}
//                       />
//                     </Box>
//                   ))}
//                 </>
//               )}

//               {/* Submit And Cancel Button */}
//               <FilterWrapper justify="flex-end" align="center" pb={6} gap={2}>
//                 {primary_filters && primary_filters.length > 0 && (
//                   <Button
//                     variant="solid"
//                     onClick={() => {
//                       handlePrimaryFilterClear();
//                     }}
//                   >
//                     Clear
//                   </Button>
//                 )}
//               </FilterWrapper>
//             </FilterWrapper>
//           </AppModal>
//         </>
//       )}
//     </>
//   );
// }