import { Box } from "@chakra-ui/react";
import { FilterWrapper, LinkList } from "../_common";
import { DeskTopFilterIcon, FilterIcon, FilterComponent } from "../_components";
import { useState } from "react";
import { isObjectEmpty } from "@/app/_utils";

export default function DesktopFilter({
  primary_filters,
  secondary_filter = [],
  handlePrimaryFilterChange,
  handlePrimaryFilterClear,
  selectedValues,
}) {
  const [reloadFilter, setReloadFilter] = useState(false);

  const handleReloadFilter = () => {
    setReloadFilter(!reloadFilter);
  }; 
 
  return (
    <FilterWrapper>
      <Box flex="1">
      {primary_filters && primary_filters.length > 0 && (
        <FilterWrapper
          gap={5}
          align="center"
          direction={{
            base: "column",
            md: "row",
          }}
        >
          {/* Filter By Icon Component */}
          <DeskTopFilterIcon />

          {/* Rendering Primary Filters */}
          {primary_filters.map(({ _id, ...restProps }) => (
            <Box key={_id}>
              <FilterComponent
                {...restProps}
                primary_filters={primary_filters}
                handlePrimaryFilterChange={handlePrimaryFilterChange}                
                selectedValuesVariable={selectedValues}
                reloadFilter={reloadFilter}
              />
            </Box>
          ))}

          {/* Rendering Clear Icon */}
          {!isObjectEmpty(selectedValues) && <FilterIcon type="clear" onClick={() => { handlePrimaryFilterClear(primary_filters); handleReloadFilter(); }} />}
        </FilterWrapper>
        )}
      </Box>

      {/* Rendering Secondary Filters */}
      {secondary_filter.length > 0 && (
        <FilterWrapper gap={5} align="center">
          {secondary_filter.map(({ _id, ...restProps }) => (
            <Box key={_id}>
              <FilterComponent
                {...restProps}
                secondary_filter={secondary_filter}
                selectedValuesVariable={selectedValues}
                reloadFilter={reloadFilter}
              />
            </Box>
          ))}
        </FilterWrapper>
      )}

      {/* Rendering Links If the the secondry filter has link key */}
      {secondary_filter?.links && <LinkList links={secondary_filter.links} />}
    </FilterWrapper>
  );
}
