import { ReactSVG } from "react-svg";
import { Box, Text, IconButton } from "@chakra-ui/react";
import { BsXLg, BsFilterLeft } from "react-icons/bs";

import { appTextFontSize } from "@/app/_components/_styles";

export function FilterIcon({ type, onClick = () => {} }) {
  return (
    
    <IconButton
      isRound={true}
      variant="solid"
      bg="orangePeel.900"
      color="#fff"
      _hover={{ color: "black" }}
      icon={type === "clear" ? <BsXLg /> : <BsFilterLeft />}
      onClick={onClick}
    />
  );
}

export function DeskTopFilterIcon() {
  return (
    <Box display="flex" gap={5}>
      <ReactSVG src="/icons/filter.svg" style={{ marginTop: "5px" }} />
      <Text
        as="p"
        fontWeight="semibold"
        color="black"
        fontSize={appTextFontSize}
      >
        Filter By
      </Text>
    </Box>
  );
}
