import { AppMultiSelect, AppDatepicker } from "@/app/_components";

import AppSelect from "./AppSelect";

const SELECT_COMPONENT = "select";
const MULTI_SELECT_COMPONENT = "multi-select";
const DATE_PICKER_COMPONENT = "date-picker";

export default function FilterComponent({
  type,
  label,
  isMobile,
  primary_filters,
  secondary_filter,
  handlePrimaryFilterChange,
  selectedValuesVariable,
  ...restFilterProps
}) {

  switch (type) {
    case SELECT_COMPONENT:
      return (
        <AppSelect
          label={label}
          options={restFilterProps.options}
          primary_filters={primary_filters}
          secondary_filter={secondary_filter}
          handlePrimaryFilterChange={handlePrimaryFilterChange}
          selectedValuesVariable={selectedValuesVariable}
        />
      );
    case MULTI_SELECT_COMPONENT:
      return (
        <AppMultiSelect
          label={label}
          options={restFilterProps?.options ?? []}
          placeholder={label}
          bordered
          isSearchable
          isClearable
          isMulti
          customWidth={
            label.toLowerCase() !== "category" && !isMobile ? true : false
          }
          primary_filters={primary_filters}
          secondary_filter={secondary_filter}
          handlePrimaryFilterChange={handlePrimaryFilterChange}
          selectedValuesVariable={selectedValuesVariable}
        />
      );
    case DATE_PICKER_COMPONENT:
      return (
        <AppDatepicker
          placeholderText="Date"
          className="default__date-picker"
          customInput
        />
      );
    default:
      break;
  }
}
