"use client";
import { Select } from "@chakra-ui/react";
import { useParams } from "next/navigation";
import { useEffect, useRef } from "react";
export default function AppSelect({
  label,
  options,
  primary_filters,
  secondary_filter,
  defaultValue,
  handlePrimaryFilterChange,
  selectedValuesVariable,
}) {
  const anchorRef = useRef(null);
  const params = useParams();

  let urlString;
  urlString = "";

  const getDefaultValue = (paramLabel) => {
    if (paramLabel === "other-categories") {
      return params.slug[1] || "";
    }
    if (
      selectedValuesVariable &&
      Object.keys(selectedValuesVariable).length !== 0 &&
      selectedValuesVariable.hasOwnProperty(paramLabel)
    ) {
      //console.log("1001: ", selectedValuesVariable[paramLabel]);
      //console.log("1002: ", paramLabel);

      if(selectedValuesVariable[paramLabel] == 0) //Ajith if and else portion full
      {
        return "";
      }
      else
      {
        return selectedValuesVariable[paramLabel];
      }
      //return selectedValuesVariable[paramLabel]; // Original
      
    } else {
      return "";
    }
  };

  //console.log("1002: ", getDefaultValue); 

  useEffect(() => {
    // This effect is to reset the anchor's href when the component unmounts
    if (secondary_filter && secondary_filter.length > 0) {
      anchorRef.current.href = ""; // Reset the anchor's href when the component unmounts
    }
  }, [secondary_filter]);

  let f = getDefaultValue(label);

  var otherCategoryFlag = true;

  if(params.slug[0] == "destination" && label == "Other Categories")
  {
    otherCategoryFlag = false;
  }

  return (
    <>
      <a ref={anchorRef} style={{ display: "none" }}></a>

      <Select
        id={label.toLowerCase().replace(/\s/g, "-")}
        name={label.toLowerCase().replace(/\s/g, "-")}
        borderColor="orangePeel.900"
        focusBorderColor="orangePeel.900"
        borderRadius="full"
        value={getDefaultValue(label.toLowerCase().replace(/\s/g, "-"))}
        defaultValue={getDefaultValue(label.toLowerCase().replace(/\s/g, "-"))}
        
        onChange={(e) => {
          let filterValue = "";

          if (primary_filters && primary_filters.length > 0) {
            const selectedValueschosen = {};
            primary_filters.forEach(({ label }) => {
              const element = document.getElementById(
                label.toLowerCase().replace(/\s/g, "-")
              );

              if (element !== null) {
                filterValue = element.value;

                if ((filterValue !== null && filterValue !== "") || filterValue == 0) {
                  selectedValueschosen[
                    label.toLowerCase().replace(/\s/g, "-")
                  ] = filterValue;
                }
              }
            });

            if (
              document.getElementById(label.toLowerCase().replace(/\s/g, "-"))
                .value == ""
            ) {
              selectedValueschosen[label.toLowerCase().replace(/\s/g, "-")] =
                "";
            }            
            handlePrimaryFilterChange(selectedValueschosen,label.toLowerCase().replace(/\s/g, "-"));
          } else if (secondary_filter && secondary_filter.length > 0) {
            secondary_filter.forEach(({ label }) => {
              filterValue = document.getElementById(
                label.toLowerCase().replace(/\s/g, "-")
              ).value;
            });

            if(params.slug[0] == "destination")
            {
                anchorRef.current.href = "/" + params.slug[0] + "/" + filterValue + "/?Region=0";
            }
            else
            {
              anchorRef.current.href = "/" + params.slug[0] + "/" + filterValue;
            }            
            anchorRef.current.click();
          }
        }}
      >
        
        { (otherCategoryFlag == true) &&
        <option value="">{label}</option>
        }
        
        {options.map(({ _id, label, value, selected ,disabled,highlighted}) => (                
          <option key={_id} value={value} disabled={disabled ? true : false} style={disabled ? { backgroundColor: 'lightgrey' } : highlighted ? { color: 'red' } : {}}>
            {label}
          </option>
        ))}
      </Select>
    </>
  );
}
