import { Flex } from "@chakra-ui/react";
import { AppLink } from "@/app/_components";

export function FilterWrapper ({ children, ...restStyleProps }) {
  return (
    <Flex {...restStyleProps}>
      { children }
    </Flex>
  )
}

export function LinkList({ links }) {
  return (
    <Flex gap={4}>
      {links.map(({ text, ...restLinkProps }, idx) => (
        <AppLink
          key={idx}
          bg="orangePeel.900"
          color="white"
          _hover={{ color: "white" }}
          px={6}
          rounded="full"
          {...restLinkProps}
        >
          {text}
        </AppLink>
      ))}
    </Flex>
  );
}
