/* eslint-disable react/prop-types */
import { useEffect, useState } from "react";
import ReactangleImage from "./Rectangle.png";

const Popup = ({
  festival,
  startDate,
  endDate,
  position, // Position of the dot
  description,
  image,
  popupRef,
  timeoutId,
  setTimeoutId,
  setHoveredEvent,
  link,
}) => {
  const formatDate = (date) => ({
    month: date.toLocaleString("default", { month: "short" }),
    day: date.getDate(),
  });

  const start = formatDate(startDate);
  const end = formatDate(endDate);

  const [adjustedPosition, setAdjustedPosition] = useState(position);

  useEffect(() => {
    if (popupRef.current) {
      const { innerWidth: viewportWidth, innerHeight: viewportHeight } = window;
      const popupWidth = popupRef.current.offsetWidth;
      const popupHeight = popupRef.current.offsetHeight;

      let { top, left } = position;

      // Adjust position so that popup appears above the dot
      top -= popupHeight + 10; // Move the popup above the dot with a small margin
      left -= popupWidth / 2; // Center the popup horizontally over the dot

      // Make sure the popup doesn't go outside the viewport
      if (left + popupWidth > viewportWidth) {
        left = viewportWidth - popupWidth - 20; // Adjust for the right edge
      } else if (left < 20) {
        left = 20; // Adjust for the left edge
      }

      if (top < 20) {
        top = position.top + 10; // Move it below the dot if there's no space above
      } else if (top + popupHeight > viewportHeight) {
        top = viewportHeight - popupHeight - 20; // Adjust for the bottom edge
      }

      setAdjustedPosition({ top, left });
    }
  }, [popupRef, position]);

  return (
    <a href={link} target="_blank">
    <div
      ref={popupRef}
      className="absolute bg-black border rounded-lg cursor-pointer flex flex-col z-1000 overflow-hidden transform"
      style={{
        top: adjustedPosition?.top,
        left: adjustedPosition?.left,
        backgroundImage: `url(${ReactangleImage})`,
        backgroundSize: "cover",
        backgroundRepeat: "no-repeat",
        width: "400px",
        maxHeight: "200px",
      }}
      onMouseEnter={() => {
        if (timeoutId) {
          clearTimeout(timeoutId);
        }
      }}
      onMouseLeave={() => {
        const id = setTimeout(() => {
          setHoveredEvent(null);
        }, 2000);
        setTimeoutId(id);
      }}
    >
      <div className="relative w-full bg-gray-100 h-full flex flex-col items-stretch">
        <div className="flex w-full bg-gray-100">
          <div className="flex w-[110px] bg-gray-100 flex-row">
            <img
              src={image}
              alt="image"
              className="w-full h-full object-cover"
            />
          </div>
          <div className="flex-2 bg-[#6A8D44] font-bold text-xl text-white text-center w-full py-5">
            {festival}
          </div>
        </div>
        <div className="flex flex-col flex-1 py-2 px-2">
          <div className="flex flex-row flex-1 items-end py-3">
            <div className="flex flex-row w-[100px]">
              <div className="flex flex-col flex-1 text-center">
                <div className="text-black font-bold mb-1">{start.month}</div>
                <div className="text-green-500 text-xl">{start.day}</div>
              </div>
              <div className="w-[1px] bg-gray-300 mx-2"></div>
              <div className="flex flex-col flex-1 text-center">
                <div className="text-black font-bold mb-1">{end.month}</div>
                <div className="text-red-500 text-xl">{end.day}</div>
              </div>
            </div>
            <div className="w-[1px] bg-white mx-2"></div>
            <div className="bg-gray-100 flex-2">{description}</div>
            <div className="flex justify-end">
              
                <button className="ml-2 text-black border border-gray-800 rounded w-[5rem]">
                  More
                </button>
              
            </div>
          </div>
        </div>
      </div>
    </div>
    </a>
  );
};

export default Popup;
