"use client";

import { Box, useMediaQuery } from "@chakra-ui/react";
import { KtContainer, SectionHeading, AppSection } from "@/app/_components";

import EssentialDeskTopView from "./_views/desktop";
import EssentialMobileView from "./_views/mobile";

export default function Essential(props) {
  const [isSmallDevice] = useMediaQuery(["(max-width: 767px)"], {
    ssr: true,
    fallback: true,
  });
  const [isDesktopAndSmallScreen] = useMediaQuery(["(min-width: 766px)"], {
    ssr: true,
    fallback: true,
  });

  return (
    <AppSection>
      <KtContainer
        sx={{
          "@media screen and (min-width: 766px)": {
            ".essential__desktop": {
              display: "block",
            },
            ".essential_mobile": {
              display: "none",
            },
          },
          "@media screen and (max-width: 767px)": {
            ".essential__desktop": {
              display: "none",
            },
            ".essential_mobile": {
              display: "block",
            },
          },
        }}
      >
        <SectionHeading
          heading="Hospitality Services"
          description="Everything you need to consider for a trip to Kerala now."
        />
        {isDesktopAndSmallScreen && (
          <Box className="essential__desktop">
            <EssentialDeskTopView {...props} />
          </Box>
        )}
        {isSmallDevice && (
          <Box className="essential_mobile">
            <EssentialMobileView {...props} />
          </Box>
        )}
      </KtContainer>
    </AppSection>
  );
}
