import dynamic from "next/dynamic";
import {
  Accordion,
  AccordionItem,
  AccordionPanel,
  AccordionButton,
  AccordionIcon,
  Box,
} from "@chakra-ui/react";

import { tabsNavigation } from "../../_data";

const WhereToStay = dynamic(() =>
  import("@/app/_components/_page/Essentials/_components").then(
    (mod) => mod.WhereToStay
  )
);
const FindTourOperator = dynamic(() =>
  import("@/app/_components/_page/Essentials/_components").then(
    (mod) => mod.FindTourOperator
  )
);
const PlanYourItinerary = dynamic(() =>
  import("@/app/_components/_page/Essentials/_components").then(
    (mod) => mod.PlanYourItinerary
  )
);

import { Advertisement, WeatherAndTourismInfo } from "@/app/_components/_page/Essentials/_components";

import {
  WHERE_TO_STAY,
  FIND_TOUR_OPERATOR,
  PLAN_YOUR_ITINERARY,
} from "../../_data";

export default function EssentialMobileView(props) {
  return (
    <>
      <Accordion allowToggle>
        {tabsNavigation.map(({ key, title }) => (
          <AccordionItem key={key} borderColor="transparent" mb={2}>
            <AccordionButton
              textTransform="uppercase"
              bg="antiFlashWhite"
              pt={6}
              pb={6}
              fontWeight="medium"
              fontSize="16"
              _hover={{
                bg: "antiFlashWhite",
              }}
              _expanded={{
                bg: "sage.900",
                color: "white",
              }}
            >
              <Box as="span" flex="1" textAlign="left">
                {title}
              </Box>
              <AccordionIcon />
            </AccordionButton>
            <AccordionPanel pb={4} pt={4} bg="antiFlashWhite">
              {key === WHERE_TO_STAY && <WhereToStay wheretostay={props} />}
              {key === FIND_TOUR_OPERATOR && <FindTourOperator findtouroperator={props} />}
              {key === PLAN_YOUR_ITINERARY && <PlanYourItinerary />}
            </AccordionPanel>
          </AccordionItem>
        ))}
      </Accordion>
      <Box bg="#EFF3F7" mt={4}>
        <Advertisement />
      </Box>
      <Box bg="#EFF3F7" mt={4}>
        <WeatherAndTourismInfo />
      </Box>

    </>
  );
}
