"use client";

import { useState } from "react";
import {
  AppTab,
  AppTabList,
  AppTabNavItem,
  AppTabIndicator,
  AppTabPanelParent,
  AppTabPanel,
} from "@/app/_components";

import TabPanelContent from "./_components";
import { tabsNavigation } from "../../_data";

export default function EssentialDeskTopView(props) {
  const [activeTab, setActiveTab] = useState(tabsNavigation[0].key);

  return (
    <AppTab
      onChange={(index) => setActiveTab(tabsNavigation[index].key)}
      isLazy
    >
      <AppTabList justifyContent="space-around" borderBottom="1px solid #ccc">
        {tabsNavigation.map(({ title }, key) => (
          <AppTabNavItem
            px="0"
            fontSize={22}
            key={key}
            pb="4"
            textTransform="uppercase"
          >
            {title}
          </AppTabNavItem>
        ))}
      </AppTabList>
      <AppTabIndicator />
      <AppTabPanelParent>
        {tabsNavigation.map((key) => (
          <AppTabPanel
            key={key}
            sx={{
              ".essential": {
                gridTemplateColumns: "repeat(3, 1fr)",
              },
              "@media screen and (max-width:1279px)": {
                ".essential": {
                  gridTemplateColumns: "repeat(2, 1fr)",
                },
                ".essential .essential__weather-tourism-info": {
                  display: "none",
                },
              },
            }}
          >
            <TabPanelContent activeTab={activeTab} props={props} />
          </AppTabPanel>
        ))}
      </AppTabPanelParent>
    </AppTab>
  );
}
