import dynamic from "next/dynamic";
import { node, bool, string } from "prop-types";
import { AnimatePresence } from "framer-motion";
import { Grid, GridItem, useMediaQuery } from "@chakra-ui/react";
import { AnimationWrapper } from "@/app/_components/AnimationWrapper";

const WhereToStay = dynamic(() =>
  import("@/app/_components/_page/Essentials/_components").then(
    (mod) => mod.WhereToStay
  )
);
const FindTourOperator = dynamic(() =>
  import("@/app/_components/_page/Essentials/_components").then(
    (mod) => mod.FindTourOperator
  )
);
const PlanYourItinerary = dynamic(() =>
  import("@/app/_components/_page/Essentials/_components").then(
    (mod) => mod.PlanYourItinerary
  )
);

import {
  Advertisement,
  WeatherAndTourismInfo,
} from "@/app/_components/_page/Essentials/_components";

import {
  WHERE_TO_STAY,
  FIND_TOUR_OPERATOR,
  PLAN_YOUR_ITINERARY,
} from "../../../_data";

const GridItemWrapper = ({ children, bg = true, className = "" }) => {
  const gridItemProps = {
    w: "full",
    h: "700px",
    borderRadius: "1%",
  };

  return (
    <GridItem
      {...gridItemProps}
      {...(bg && { bg: "antiFlashWhite" })}
      {...(className && {
        className,
      })}
    >
      {children}
    </GridItem>
  );
};

GridItemWrapper.propTypes = {
  children: node.isRequired,
  bg: bool,
  className: string,
};

const FadeInWrapper = ({ children }) => {
  return (
    <AnimationWrapper
      h="full"
      overflow={false}
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      exit={{ opacity: 0 }}
    >
      {children}
    </AnimationWrapper>
  );
};

FadeInWrapper.propTypes = {
  children: node.isRequired,
};

export default function TabPanelContent({ activeTab, props }) {
  const [isSmallScreen] = useMediaQuery(["(max-width: 1048px)"]);
  return (
    <Grid gap={5} className="essential">
      <GridItemWrapper>
        <AnimatePresence>
          {activeTab === WHERE_TO_STAY && (
            <FadeInWrapper>
              <WhereToStay wheretostay={props} />
            </FadeInWrapper>
          )}
          {activeTab === FIND_TOUR_OPERATOR && (
            <FadeInWrapper>
              <FindTourOperator findtouroperator={props} />
            </FadeInWrapper>
          )}
          {activeTab === PLAN_YOUR_ITINERARY && (
            <FadeInWrapper>
              <PlanYourItinerary planyouritinerary={props} />
            </FadeInWrapper>
          )}
        </AnimatePresence>
      </GridItemWrapper>
      <GridItemWrapper className="essential__advertisement">
        <Advertisement />
      </GridItemWrapper>
      {!isSmallScreen && (
        <GridItemWrapper className="essential__weather-tourism-info">
          <WeatherAndTourismInfo />
        </GridItemWrapper>
      )}
    </Grid>
  );
}

TabPanelContent.propTypes = {
  activeTab: string.isRequired,
};
