import { node, string, oneOf } from "prop-types";
import { forwardRef } from "react";

import { BsChevronRight } from "react-icons/bs";
import { Box, Flex, FormLabel, Input } from "@chakra-ui/react";

import { AppButton, AnimationWrapper } from "@/app/_components";

export function RootWrapper({ children, ...restProps }) {
  return (
    <AnimationWrapper
      p={{
        md: 4,
        lg: 12,
        xl: 6,
        "2xl": 12,
      }}
      h="full"
      overflow={false}
      initial={{ y: 10, opacity: 0 }}
      animate={{ y: 0, opacity: 1 }}
      exit={{ y: -10, opacity: 0 }}
      transition="0.2s ease"
      {...restProps}
    >
      <Flex direction="column" gap={12} h="full" justifyContent="center">
        {children}
      </Flex>
    </AnimationWrapper>
  );
}

RootWrapper.propTypes = {
  children: node.isRequired,
};

export function FormInputLabel({ title, ...restStyleProps }) {
  return (
    <FormLabel
      color="#BEBEBE"
      fontWeight="normal"
      fontSize="20px"
      {...restStyleProps}
    >
      {title}
    </FormLabel>
  );
}

FormInputLabel.propTypes = {
  title: string.isRequired,
};

export const ItemInput = forwardRef(({ placeholder, ...restProps }, ref) => {
  return (
    <Input
      variant="flushed"
      ref={ref}
      placeholder={placeholder}
      borderColor="sage.900"
      _placeholder={{
        color: "#939395",
        fontSize: "18px",
      }}
      _focusWithin={{
        borderColor: "inherit",
        boxShadow: "0px 2px 0px 0px #9CA777",
      }}
      {...restProps}
    />
  );
});

ItemInput.displayName = "ItemInput";

export function EssentialButton({
  children,
  variant = "white",
  rightIcon = false,
  onClick = () => {},
}) {
  return (
    <AppButton variant={variant} onClick={onClick}>
      {children}
      {rightIcon && <BsChevronRight strokeWidth={1} fontSize="12px" />}
    </AppButton>
  );
}

EssentialButton.propTypes = {
  children: node.isRequired,
  variant: oneOf(["white", "black", "none"]),
};
