import { useCallback, useState } from "react";

import { useRouter } from "next-nprogress-bar";
import { Box } from "@chakra-ui/react";

import { AppWhMultiSelect } from "@/app/_components";
import { RootWrapper, FormInputLabel, EssentialButton } from "../_includes";
import Swal from 'sweetalert2';

const destinations = [
  { value: "munnar", label: "Munnar" },
  { value: "kovalam", label: "Kovalam" },
  { value: "koodamkulam", label: "KoodamKulam" },
  { value: "kovilakam", label: "Kovilakam" },
  { value: "kodakka", label: "Kodakkal" },
];

const categories = [
  { value: "homestay", label: "Home Stay" },
  { value: "hotels", label: "Hotels" },
  { value: "ayurvedha_center", label: "Ayurvedha Center" },
  { value: "house_boats", label: "House Boats" },
  { value: "resorts", label: "Resorts" },
  { value: "serviced-villas", label: "Serviced Villas" },
];

export default function WhereToStay(wheretostay) {
  const [destination, setDestination] = useState([]);
  const [category, setCategory] = useState("");
 
  const data = wheretostay;

  const categories= data && data.wheretostay && data.wheretostay.items && data.wheretostay.items.where_to_stay  && data.wheretostay.items.where_to_stay.categories && data.wheretostay.items.where_to_stay.categories.options ;

  const nmwhr = data && data.wheretostay && data.wheretostay.items && data.wheretostay.items.where_to_stay  && data.wheretostay.items.where_to_stay.categories && data.wheretostay.items.where_to_stay.categories.label;

  const destinations= data && data.wheretostay && data.wheretostay.items && data.wheretostay.items.where_to_stay  && data.wheretostay.items.where_to_stay.destinations && data.wheretostay.items.where_to_stay.destinations.options ;

  const nmdes = data && data.wheretostay && data.wheretostay.items && data.wheretostay.items.where_to_stay  && data.wheretostay.items.where_to_stay.destinations && data.wheretostay.items.where_to_stay.destinations.label;

  const router = useRouter(); 
  
  function handleSubmit() {
      if (destination.length === 0)
      {
          //alert('Please choose location');
          Swal.fire({
            icon: 'info',
            title: 'Please choose location.',
          }); 
          return false;
      }

      if (category.length === 0)
      {
         // alert('Please choose category');
          Swal.fire({
            icon: 'info',
            title: 'Please choose category.',
          }); 
          return false;
      }

      var resultdest = destination.join('-');
      //router.push("/where-to-stay?category="+category+"&destination="+resultdest);
      //router.push("/where-to-stay/");

      window.open("http://202.88.244.195/keralatourism.org/2024/where-to-stay/?category="+category+"&destination=" + resultdest, '_blank');

      /* const formData = new FormData();
   
      formData.append("destination", resultdest);
      formData.append("category", category);   

    const form = document.createElement("form");
    form.method = "POST";
    form.action = "https://www.keralatourism.org/nextjs-post-value"; 
   

    formData.forEach((value, key) => {
      const input = document.createElement("input");
      input.type = "hidden";
      input.name = key;
      input.value = value;
      form.appendChild(input);
    });

    const newTab = window.open('', '_blank');
    newTab.document.body.appendChild(form);    
    form.submit(); */
  };

  function handleDestinationChange(valdes) {
    setDestination(valdes);
  }

  function handleCategoryChange(valcat) {
    setCategory(valcat);
  }
  return (
    <RootWrapper>
      <Box>
        <FormInputLabel title="Destinations" />
        <AppWhMultiSelect
          placeholder="Enter Locations"
          options={destinations}
          isSearchable
          isClearable
          handleDestinationChange={handleDestinationChange}
          hfn="location"
          nm = {nmdes}
        />
      </Box>
      <Box>
        <FormInputLabel title="Categories" />
        <AppWhMultiSelect
          placeholder="Select your category"
          options={categories}
          isClearable         
          handleCategoryChange={handleCategoryChange}
          hfn="cat"
          nm = {nmwhr}
        />
      </Box>
      <EssentialButton onClick={handleSubmit}>Submit</EssentialButton>
    </RootWrapper>
  );
}