import { ReactSVG } from "react-svg";
import { Box, VStack, StackDivider, Flex, Text } from "@chakra-ui/react";
import { KtHeading, AppLink } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from 'next/link'

export default function WeatherAndTourismInfo() {
  return (
    <Box
      p={{
        base: 4,
        md: 8,
      }}
      h="full"
    >
      <VStack
        divider={<StackDivider borderColor="sage.900" />}
        spacing={12}
        h="full"
        align="center"
      >
        <Box>
          <Flex direction="column" gap={8} alignItems="center">

            <KtHeading as="h6" color="russian.900" textAlign="center">
            <Link
                
                href="http://202.88.244.195:3000/information-offices/" target="_blank"
                
              >Tourist  <br /> Information Centers</Link>
            </KtHeading>
            <Link
                
                href="http://202.88.244.195:3000/information-offices/" target="_blank"
                
              ><ReactSVG src="/icons/tourist_information.svg" /></Link>
            
           
          </Flex>
        </Box>
        <Box>
          <Flex direction="column" gap={8} alignItems="center">
            <KtHeading as="h6" color="russian.900" textAlign="center">
            <Link
                
                href="https://www.keralatourism.org/tourist-guide-portal/" target="_blank"
                
              >
            Tour Guide
            </Link>

            </KtHeading>
            <Link
                
                href="https://www.keralatourism.org/tourist-guide-portal/" target="_blank"
                
              >
            <ReactSVG src="/icons/how_to_reach.svg" /></Link>
            
            <Box display="inline-flex">
            <AppLink
                type="external"
                color="black"
                variant="pill"
                title="Learn More"
                parent="https://www.keralatourism.org/tourist-guide-portal/"
                arrow
              >
                Learn More
              </AppLink>
            </Box>
          </Flex>
        </Box>
      </VStack>
    </Box>
  );
}