import { AnimatePresence } from "framer-motion";
import { useState, useCallback } from "react";
import { useRouter } from "next-nprogress-bar";

import { RootWrapper } from "../../_includes";

import StepOne from "./_components/StepOne";
import StepTwo from "./_components/StepTwo";
import StepThree from "./_components/StepThree";
import StepFour from "./_components/StepFour";

export default function PlanYourItinerary() {

  const router = useRouter();
  const [activeStep, setActiveStep] = useState(1);
  const [availability, setAvailability] = useState("Fixed");

  const [start_point, setStartPoint] = useState();
  const [destination_point, setDestinationPoint] = useState();

  const [customer_name, setCustomerName] = useState();
  const [email, setemail] = useState();

  const [trip_date, setTripDate] = useState();

  const [destination, setDestination] = useState([]);

  const handleNext = useCallback(() => {
    /*setActiveStep((prev) => 
    {
      console.log("xxxx");
      console.log(prev);
      prev + 1;
    });*/
    setActiveStep((prev) => prev + 1);
  }, []);

  const handlePrevious = useCallback(() => {
    setActiveStep((prev) => prev - 1);
  }, []);

  /*const handleSubmit = useCallback(() => {
    console.log("test1");
    console.log(start_point);
    console.log("test2");
    console.log(destination_point);
    console.log("test3");
    console.log(availability);
    console.log("test4");
    console.log(trip_date);
    //router.push("/plan-your-itinerary");
  }, []);*/

  function handleSubmit() {
    /*console.log("test1");
    console.log(start_point);
    console.log("test2");
    console.log(destination_point);
    console.log("test3");  
    console.log(availability);
    console.log("test4");
    console.log(trip_date);*/
    const date1 = new Date(trip_date);
    const formattedDate = `${date1.getDate()}-${date1.getMonth() + 1}-${date1.getFullYear()}`;
    //console.log(formattedDate);
    /*console.log("test5");
    console.log(customer_name);
    console.log("test6");
    console.log(email);*/

    //router.push("/plan-your-itinerary/?start_point="+start_point+"&destination_point="+destination_point+"&trip_date="+formattedDate+"&customer_name="+customer_name+"&email="+email);

    window.open("http://202.88.244.195/keralatourism.org/plan-your-itinerary/?start_point="+start_point+"&destination_point="+destination_point+"&trip_date="+formattedDate+"&customer_name="+customer_name+"&email="+email, '_blank');
  }

  return (
    <AnimatePresence mode="wait">
      {activeStep === 1 && (
        <RootWrapper key={activeStep}>
          <StepOne
            start_point={start_point}
            setStartPoint={setStartPoint}
            destination_point={destination_point}
            setDestinationPoint={setDestinationPoint}
            setAvailability={setAvailability}
            availability={availability}
            handleNext={handleNext}
            destination={destination}
            setDestination={setDestination}            
          />
        </RootWrapper>
      )}
      {activeStep === 2 && (
        <RootWrapper key={activeStep}>
          <StepTwo
            trip_date={trip_date}
            setTripDate={setTripDate}
            handleNext={handleNext} 
            handlePrevious={handlePrevious} 
          />
        </RootWrapper>
      )}
      {activeStep === 3 && (
        <RootWrapper key={activeStep}>
          <StepFour
            customer_name={customer_name}
            setCustomerName={setCustomerName}
            email={email}
            setemail={setemail}
            handleSubmit={handleSubmit} />
        </RootWrapper>
      )}
      {activeStep === 4 && (
        <RootWrapper key={activeStep}>
          <StepFour
            customer_name={customer_name}
            setCustomerName={setCustomerName}
            email={email}
            setemail={setemail}
            handleSubmit={handleSubmit} />
        </RootWrapper>
      )}
    </AnimatePresence>
  );
}
