import { Box, Flex } from "@chakra-ui/react";

import { CalendarContainer } from "react-datepicker";
import { subDays } from "date-fns";

import { AppDatepicker } from "@/app/_components";
import { EssentialButton } from "../../../_includes";

const StepTwo = ({ trip_date, setTripDate, handleNext, handlePrevious }) => {
  const CustomContainer = ({ className, children }) => {
    return (
      <Box
        p={{
          md: 4,
        }}
        bg="white"
        shadow="md"
        sx={{
          "@media  screen and (max-width:767px)": {
            w: "50%",
            mx: "auto",
          },
          "@media  screen and (max-width:699px)": {
            w: "55%",
            mx: "auto"
          },
          "@media  screen and (max-width:634px)": {
            w: "60%",
            mx: "auto"
          },
          "@media  screen and (max-width:575px)": {
            w: "65%",
            mx: "auto"
          },
          "@media  screen and (max-width:500px)": {
            w: "75%",
            mx: "auto"
          },
          "@media  screen and (max-width:479px)": {
            w: "full",
          }
        }}
      >
        <CalendarContainer 
          className={className}
        >
          <Box pos="relative" bg="white">
            {children}
          </Box>
        </CalendarContainer>
        <Flex
          gap={2}
          direction="column"
          px={{ base: 4, md: 0 }}
          py={{ base: 4, md: 0 }}
        >
          <EssentialButton onClick={handleNext} rightIcon>
            Continue
          </EssentialButton>
          <EssentialButton variant="none" onClick={handlePrevious}>
            Cancel
          </EssentialButton>
        </Flex>
      </Box>
    );
  };

  // Highlight Range Dates
  const highlightWithRanges = [
    {
      "react-datepicker__day--highlighted-fixed": [
        subDays(new Date(), 5),
        subDays(new Date(), 6),
        subDays(new Date(), 7),
        subDays(new Date(), 8),
      ],
    },
  ];

  return (
    <AppDatepicker
      calendarContainer={CustomContainer}
      calendarClassName="essentials"
      highlightDates={highlightWithRanges}
      selectsRange
      inline
      value={trip_date}
      onChange={(trip_date) => setTripDate(trip_date)}
    />
  );
};

export default StepTwo;
