import { Box, Flex, Text } from "@chakra-ui/react";

import { appTextFontSize } from "@/app/_components/_styles";
import { useDispatchContext } from "@/app/_context";

import { EssentialButton } from "../../../_includes";

const StepThree = ({ handleNext }) => {
  const dispatch = useDispatchContext();

  return (
    <Box
      p={{
        base: 4,
        md: 12,
      }}
      bg="white"
      borderRadius="md"
    >
      <Flex direction="column" gap={6}>
        <Text as="p" fontSize={appTextFontSize}>
          Every day is a lazy, laid-back day here if you want it to be, that is.
        </Text>
        {/*<EssentialButton
          onClick={() => dispatch({ type: "HANDLE_SIGNIN_MODAL", value: true })}
          rightIcon
        >
          Sign In
        </EssentialButton>
        <EssentialButton
          variant="black"
          onClick={() => dispatch({ type: "HANDLE_SIGNUP_MODAL", value: true })}
          rightIcon
        >
          Sign Up
        </EssentialButton>*/}
        <EssentialButton variant="none" onClick={handleNext} rightIcon>
          Continue as guest
        </EssentialButton>
      </Flex>
    </Box>
  );
};

export default StepThree;
