import { Box, Stack, RadioGroup, Radio } from "@chakra-ui/react";
import { FormInputLabel, ItemInput, EssentialButton } from "../../../_includes";

const StepOne = ({ start_point, setStartPoint, destination_point, setDestinationPoint, setAvailability, availability, handleNext }) => {
  return (
    <>
      <Box>
        <FormInputLabel title="Starting Place" />
        <ItemInput 
        placeholder="Starting Point"
        value={start_point}
        onChange={(e) => setStartPoint(e.target.value)} 
        />
      </Box>
      <Box>
        <FormInputLabel title="Destination" />
        <ItemInput 
        placeholder="Destination"
        value={destination_point}
        onChange={(e) => setDestinationPoint(e.target.value)}
        />
      </Box>
      {/*<Box>
        <FormInputLabel title="Availability" />
        <RadioGroup onChange={setAvailability} value={availability}>
          <Stack
            direction="row"
            gap={{
              base: 2,
              md: 6,
            }}
          >
            {["Fixed", "Flexible", "Anytime"].map((item) => (
              <Radio key={item} value={item} size="lg" spacing={2}>
                {item}
              </Radio>
            ))}
          </Stack>
        </RadioGroup>
      </Box>*/}
      <EssentialButton onClick={handleNext} rightIcon>
        Next
      </EssentialButton>
    </>
  );
};

export default StepOne;
