import { Box, Flex, Text, Input } from "@chakra-ui/react";

import { appTextFontSize } from "@/app/_components/_styles";
import { EssentialButton } from "../../../_includes";

const StepFour = ({ customer_name, setCustomerName, email, setemail, handleSubmit }) => {
  return (
    <Box
      p={{
        base: 4,
        md: 12,
      }}
      bg="white"
      borderRadius="md"
    >
      <Flex direction="column" gap={8}>
        <Text as="p" fontSize={appTextFontSize}>
          Every day is a lazy, laid-back day here if you want it to be, that is.
        </Text>
        <Box>
          <Input
            value={customer_name}
            onChange={(e) => setCustomerName(e.target.value)}
            variant="flushed"
            placeholder="Name"
            focusBorderColor="orangePeel.900"
            type="text"
          />
        </Box>
        <Box>
          <Input
            value={email}
            onChange={(e) => setemail(e.target.value)}
            variant="flushed"
            placeholder="Email"
            focusBorderColor="orangePeel.900"
            type="email"
          />
        </Box>
        <EssentialButton onClick={handleSubmit} rightIcon>
          Continue
        </EssentialButton>
      </Flex>
    </Box>
  );
};

export default StepFour;
