import { useCallback, useState } from "react";

import { Box } from "@chakra-ui/react";
import { useRouter } from "next-nprogress-bar";
import { AppWhMultiSelect, AppButton } from "@/app/_components";

import { RootWrapper, FormInputLabel, EssentialButton } from "../_includes";
import Swal from 'sweetalert2';

const districts = [
  { value: "thiruvanathapuram", label: "Thiruvanathapuram" },
  { value: "kollam", label: "Kollam" },
  { value: "pathnamathitta", label: "Pathanamthitta" },
  { value: "Kottayam", label: "Kottayam" },
  { value: "idukki", label: "Idukki" },
  { value: "ernakulam", label: "Ernakulam" },
];

export default function FindTourOperator(findtouroperator) {
  const [opdestination, setOpDestination] = useState("");

  const router = useRouter();

  const data = findtouroperator;

  const districts = data && data.findtouroperator && data.findtouroperator.items && data.findtouroperator.items.find_op  && data.findtouroperator.items.find_op.districts && data.findtouroperator.items.find_op.districts.options ;

  const nmopdes = data && data.findtouroperator && data.findtouroperator.items && data.findtouroperator.items.find_op  && data.findtouroperator.items.find_op.destinations && data.findtouroperator.items.find_op.districts.label;

  //const handleSubmit = useCallback(() => {
  function handleSubmit() {
    if (opdestination.length === 0)
    {
      Swal.fire({
        icon: 'info',
        title: 'Please choose district.',
      }); 
       // alert('Please choose district');
        return false;
    }

    var resultopdest = opdestination.join('-');

    //router.push("/tour-operator/?district="+resultopdest);
    //router.push("https://www.keralatourism.org/where-to-stay?category=12&district="+resultopdest);
    window.open("https://www.keralatourism.org/2024/where-to-stay/?category=12&district=" + resultopdest, '_blank');
    /* const formData = new FormData();
   
    formData.append("district", resultopdest);
    formData.append("category", 12);   

    const form = document.createElement("form");
    form.method = "POST";
    form.action = "https://www.keralatourism.org/nextjs-post-value";
    //form.action = "http://202.88.244.195/keralatourism.org/nextjs-post-value"; 

    formData.forEach((value, key) => {
      const input = document.createElement("input");
      input.type = "hidden";
      input.name = key;
      input.value = value;
      form.appendChild(input);
    });

    const newTab = window.open('', '_blank');
    newTab.document.body.appendChild(form);    
    form.submit(); */ 
  }  

  function handleOpDestinationChange(valdes) {
    setOpDestination(valdes);
  }

  return (
    <RootWrapper>
      <Box>
        <FormInputLabel title="District" />
        <AppWhMultiSelect
          placeholder="Enter District"
          options={districts}
          handleOpDestinationChange={handleOpDestinationChange}
          isSearchable
          isClearable  
          hfn="op" 
          nm = {nmopdes}       
        />
      </Box>
      <EssentialButton onClick={handleSubmit}>Submit</EssentialButton>
    </RootWrapper>
  );
}
