import { ReactSVG } from "react-svg";
import { Box, VStack, StackDivider, Flex, Text } from "@chakra-ui/react";
import { KtHeading, AppLink } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from 'next/link'

export default function Advertisement() {
  return (
    <Box
      p={{
        base: 4,
        md: 8,
      }}
      h="full"
    >
      <VStack
        divider={<StackDivider borderColor="sage.900" />}
        spacing={12}
        h="full"
        align="center"
      >
        <Box>
          <Flex direction="column" gap={8} alignItems="center">

            <KtHeading as="h6" color="russian.900" textAlign="center">
            <Link
                
                href="https://www.keralatourism.org/yatrinivas/" target="_blank"
                
              >Yathri Nivas <br /> Online Reservations</Link>
            </KtHeading>
            <Link
                
                href="https://www.keralatourism.org/yatrinivas/" target="_blank"
                
              ><ReactSVG src="/icons/practical_info.svg" /></Link>
            
            
          </Flex>
        </Box>
        <Box>
          <Flex direction="column" gap={8} alignItems="center">
            <KtHeading as="h6" color="russian.900" textAlign="center">
            <Link
                
                href="https://www.keralatourism.org/2024/travelcare/" target="_blank"
                
              >
            Travel Care</Link>

            </KtHeading>
            <Link
                
                href="https://www.keralatourism.org/2024/travelcare/" target="_blank"
                
              >
            <ReactSVG src="/icons/plan_your_itinerary.svg" /></Link>
            
            <Box display="inline-flex">
            <AppLink
                type="external"
                color="black"
                variant="pill"
                title="Learn More"
                parent="https://www.keralatourism.org/2024/travelcare/"
                arrow
              >
                Learn More
              </AppLink>
            </Box>
          </Flex>
        </Box>
      </VStack>
    </Box>
  );
}