"use client";

import {
  Box,
  Card,
  CardBody,
  Grid,
  Flex,
  Heading,
  Text,
} from "@chakra-ui/react";
import {
  KtContainer,
  AppLink,
  AppSection,
  AppImage,
} from "@/app/_components";

import Link from "next/link";
export default function Ebrochure({
  _id = "",
  heading,
  description,
  image: { url, alt, base64 },
  link: { text, type, parent, slug, ...restLinkProps },
  scroll_key = ""
}) {
  const sectionId = scroll_key != "" ? scroll_key : _id;
  let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank";

  return (
    <AppSection sectionHeading={false}  id={sectionId}>
      <KtContainer>
        <Card bg="antiFlashWhite">
          <CardBody p={0}>
            <Grid
              templateColumns={{
                base: "repeat(1, 1fr)",
                //md: "repeat(2, 1fr)",
                md: "1fr 1fr"
              }}
            ><Link href={ur} title={heading} target={trg} >
              <AppImage
                src={url}
                alt={alt}
                title={alt}
                blurDataURL={base64}
                width={544}
                height={448}
                style={{ height: "100%", width: "100%" }}
              />
              </Link>
              <Flex
                direction="column"
                gap={5}
                px={{
                  base: 4,
                  md: 8,
                }}
                py={{
                  base: 4,
                  lg: 0,
                }}
                justify="center"
              >
                <Heading as="h6" color="orangePeel.900" fontSize="20px">
                  E-BROCHURE
                </Heading>
                <Link href={ur} title={heading} target={trg} >
                <Heading as="h4" fontSize="30px">
                  {heading}
                </Heading>
                </Link>
                <Text as="p">{description}</Text>
                <Box diplay="inline-flex">
                  <AppLink title={heading}   type={type}  parent={parent}  slug = {slug}  
                    {...restLinkProps}
                    variant="pill"
                    color="black"
                    arrow
                  >
                    {text}
                  </AppLink>
                </Box>
              </Flex>
            </Grid>
          </CardBody>
        </Card>
        {/* <Card direction={{ base: "column", lg: "row" }} bg="antiFlashWhite">
          <AppImage
            src={url}
            alt={alt}
            blurDataURL={base64}
            width={544}
            height={448}
            style={{ height: "100%", width: "100%" }}
          />
          <CardBody
            p={{
              base: 4,
              md: 14,
            }}
          >
            <Flex direction="column" gap={5}>
              <Heading as="h6" color="orangePeel.900" fontSize="20px">
                E-BROCHURE
              </Heading>
              <Heading as="h4" fontSize="30px">
                {heading}
              </Heading>
              <Text as="p">{description}</Text>
              <Box diplay="inline-flex">
                <AppLink
                  {...restLinkProps}
                  variant="pill"
                  color="black"
                  arrow
                >
                  {text}
                </AppLink>
              </Box>
            </Flex>
          </CardBody>
        </Card> */}
      </KtContainer>
    </AppSection>
  );
}
