import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import Ebrochure from ".";

export async function EbrouchureLoader(props) {
  const updatedData = JSON.parse(
    JSON.stringify(props)
    .replace(new RegExp(`http://${process.env.HOST_IP}|http://${process.env.LOCAL_IP}`, 'g'), process.env.LOCAL_URL)
    .replace(new RegExp(`http://${process.env.MASK_IP}`, 'g'), process.env.PUBLIC_URL)
);
  let reducedResults = updatedData;
  const {
    image: { url },
  } = reducedResults;

  await getBase64ImageUrl(url).then((result) => {
    reducedResults = {
      ...reducedResults,
      image: {
        ...reducedResults.image,
        base64: result,
      },
    };
  });

  return <Ebrochure {...reducedResults} />;
}
