import { string, shape } from "prop-types";
import { Grid, GridItem, Flex, Box, Text } from "@chakra-ui/react";
import {
  KtHeading,
  KtContainer,
  AppLink,
  AppImage,
} from "@/app/_components";

export default function MicroBannerInfo({
  heading,
  description,
  image: { url, alt },
  link: { text, ...restLinkProps },
}) {
  return (
    <KtContainer
      pos="absolute"
      top="20%"
      bottom="20%"
      transform="translateX(-50%)"
      left="50%"
    >
      <Grid
        templateColumns="repeat(2, 1fr)"
        h="full"
        color="white"
        gap={5}
        placeContent="center"
      >
        <GridItem>
          <Flex direction="column" h="full" justify="center" gap={5}>
            <KtHeading as="h3" color="white">
              {heading}
            </KtHeading>
            <Box maxW="2xl">
              <Text as="p">{description}</Text>
            </Box>
            <Box display="inline-flex">
              <AppLink variant="pill" color="white" arrow {...restLinkProps}>
                {text}
              </AppLink>
            </Box>
          </Flex>
        </GridItem>
        <GridItem>
          <AppImage
            src={url}
            alt={alt}
            title={alt}
            width={960}
            height={540}
            style={{ width: "100%", borderRadius: "1%" }}
          />
        </GridItem>
      </Grid>
    </KtContainer>
  );
}

MicroBannerInfo.propTypes = {
  heading: string.isRequired,
  description: string.isRequired,
  image: shape({
    url: string.isRequired,
    alt: string.isRequired,
  }).isRequired,
};
