import { BsFillCircleFill } from "react-icons/bs";
import { Box, Stack, Divider, Text, IconButton } from "@chakra-ui/react";

export default function Caption({ caption, foodType }) {
  return (
    <Stack
      maxW="md"
      direction="row"
      height="auto"
      h={{
        base: "full",
        lg: "50px",
      }}
      align="center"
      gap={5}
    >
      {foodType && (
        <Box
          sx={{
            "svg circle": {
              fill: foodType === "veg" ? "#7AB997" : "#FC7373",
            },
          }}
        >
          <IconButton
            bg="transparent"
            borderColor="white"
            borderWidth="thin"
            icon={<BsFillCircleFill />}
            size="sm"
          />
        </Box>
      )}
      <Divider
        orientation="vertical"
        borderLeftWidth={3}
        borderColor="white"
        opacity={1}
      />
      <Text color="white">{caption}</Text>
    </Stack>
  );
}
