"use client";
import { useEffect, useState, useCallback, useRef } from "react";
import { Box, Flex, Text } from "@chakra-ui/react";
import { useMediaQuery } from "@chakra-ui/react";
import {
  
  AppSection,
  
  AppImage,
} from "@/app/_components";


import { appTextFontSize } from "@/app/_components/_styles";
import VideoControls from "../../Slider/_categories/Main/_components/VideoControls";


export default function BannerVideo({  description, video: { desktop_file, md_file, tab_file, mobile_file, poster_image, poster_md, poster_tab, poster_mobile},  isMobile, banner, alt, mediaQueryFallback}) {

  /// Setting Video URL based on Screen Size ///
  const [isLargeDesktop] = useMediaQuery("(min-width: 1921px)", {
    ssr: true,
    fallback: mediaQueryFallback,
  });

  const [isDesktop] = useMediaQuery("(min-width: 768px) and (max-width: 1920px)", {
    ssr: true,
    fallback: mediaQueryFallback,
  });

  const [isDesktop1024] = useMediaQuery("(min-width: 1024px) and (max-width: 1024px)", {
    ssr: true,
    fallback: mediaQueryFallback,
  });
  let videoURL = md_file;
  if (isLargeDesktop) videoURL=desktop_file;
  if (isDesktop) videoURL=md_file;
  if (isDesktop1024) videoURL=tab_file;

  let poster_image_url = poster_md;
  if (isLargeDesktop) poster_image_url=poster_image;
  if (isDesktop) poster_image_url=poster_md;
  if (isDesktop1024) poster_image_url=poster_tab;  

////
  const [audioState, setAudioState] = useState(true);
  const [playing, setPlaying] = useState(true);
  
// Video element ref
const videoRef = useRef(null);
useEffect(() => {
if (videoRef?.current) {
  handleVideoStates("play");
}
}, [videoRef]);

 /**
   * Handling Video States / Play / Pause / Audio
   */
 const handleVideoStates = useCallback(
  (type) => {
    if (type === "play") {
      videoRef.current.play();
      setPlaying(true);
    } else if (type === "pause") {
      videoRef.current.pause();
      setPlaying(false);
    } else if (type === "audio") {
      setAudioState(!audioState);
    }
  },
  [audioState]
);

  const bannerImageStyle = {
    width: "100%",
    borderRadius: !banner ? "0.5rem" : 0,
  };

  const bannerImageCommonProps = {
    alt,
    width: !isMobile ? 1920 : 500,
    height: !isMobile ? 1080 : 300,
    priority: true,
    sizes: "100vw",
  };

  if (isMobile) {
  return (
     
      <AppImage
        src={poster_mobile}
        {...bannerImageCommonProps}
        style={{ ...bannerImageStyle, height: "auto" }}
      />
    );
  
}


return (
  <AppSection explore>
    <Box as="div" pos="absolute"  top="0"  height="100vh"  w="full" >
      <Box
        as="span"
        pos="absolute"
        w="full"
        h="full"
      />
     <Box
        height="full"
        width="full"
        overflow="hidden"
      >
        <video
            key="VideoBannerBackground"
            height="full"
            width="full"
            objectFit="cover"
            ref={videoRef}
            src={videoURL}
            poster={poster_image_url}
            preload="metadata"
            onContextMenu={(e) => e.preventDefault()}
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition="0.5s linear"
            playsInline
            muted={audioState}
            autoPlay
            style={{ objectFit: "cover", width: "100%", height: "100%" }}
            loop
          />
      </Box>

      <Box
        pos="absolute"
        top={0}
        bottom={0}
        w="full"
        h="full"
        overflow={{
          base: "hidden",
          lg: "auto",
        }}
      >
        <Box
          display="grid"
          gridTemplateColumns={{
            base: "repeat(1, 1fr)",
            lg: "repeat(2, 1fr)",
          }}
          h="full"
        >
          <Flex
            justify={{
              base: "center",
              md: "flex-start",
              lg: "center",
            }}
            align="center"
            h="full"
            gap={{
              base: 3,
              lg: 0,
            }}
          >
            <Box
              as="div"
              w={{
                base: "100%",
                md: "sm",
              }}
              pt={{
                base: 4,
                sm: 4,
              }}
              pl={{
                base: 4,
                lg: 0,
              }}
              pr={{
                base: 4,
                lg: 0,
              }}
            >
              
              <Text as="p" color="white" fontSize={appTextFontSize}>
                {description}
              </Text>
              
            </Box>
            
            <Box pos="absolute" bottom={20} right={100} p={3}>  {/* Aligned to bottom right with padding */}
      <Flex align="center">  {/* Center controls vertically */}
        <VideoControls
          playing={playing}
          audioState={audioState}
          handleVideoStates={handleVideoStates}
        />
      </Flex>
    </Box>
            
          </Flex>
          
        </Box>
        
      </Box>
    </Box>
    
  </AppSection>
);


}
