import { shape, string, bool } from "prop-types";
import { AppImage } from "@/app/_components";

export default function BannerImage({ url, alt, base64, banner, isMobile }) {
  const { desktop, mobile } = url;
  const bannerImageStyle = {
    width: "100%",
    borderRadius: !banner ? "0.5rem" : 0,
  };

  const bannerImageCommonProps = {
    alt,
    width: !isMobile ? 1920 : 500,
    height: !isMobile ? 1080 : 300,
    priority: true,
    sizes: "100vw",
  };

  if (isMobile) {
    return (
      <AppImage 
       title={alt}       
        src={mobile}
        blurDataURL={base64["mobile"]}
        {...bannerImageCommonProps}
        style={{ ...bannerImageStyle, height: "auto" }}
      />
    );
  }

  return (
    <AppImage
      title={alt}
      src={desktop}
      blurDataURL={base64["desktop"]}
      {...bannerImageCommonProps}
      style={{ ...bannerImageStyle, height: "100%", objectFit: "cover" }}
    />
  );
}

BannerImage.propTypes = {
  url: shape({
    desktop: string.isRequired,
    mobile: string.isRequired,
  }).isRequired,
  alt: string.isRequired,
  banner: bool.isRequired,
  isMobile: bool.isRequired,
};
