"use client";

import { Box, IconButton, useDisclosure } from "@chakra-ui/react";

import { BsEye } from "react-icons/bs";

import { LightBoxContextProvider } from "@/app/_context";
import { AppGalleryLightBox } from "@/app/_components";

export default function BannerGallery({ gallery }) {
  const { isOpen, onOpen, onClose } = useDisclosure();
  return (
    <Box>
      <IconButton
        fontSize="24px"
        color="white"
        _hover={{
          bg: "blackAlpha.300",
          "svg path": {
            color: "orangePeel.900",
          },
        }}
        bg="blackAlpha.500"
        icon={<BsEye />}
        onClick={() => onOpen()}
        isRound
      />

      <LightBoxContextProvider data={{ gallery }}>
        <AppGalleryLightBox isOpen={isOpen} onClose={onClose} />
      </LightBoxContextProvider>
    </Box>
  );
}
