"use client";

import dynamic from "next/dynamic";

import { isObjectEmpty } from "@/app/_utils";
import { BannerCaptionWrapper } from "../_wrappers";

const BannerGallery = dynamic(() => import("./BannerGallery"));
const Caption = dynamic(() => import("./Caption"));

export default function BannerCaption({
  caption = "",
  gallery = {},
  food_type = "",
  isMobile,
  isMain,
}) {
  return (
    <BannerCaptionWrapper>
      {!isObjectEmpty(gallery) && (
        <BannerGallery gallery={gallery} isMain={isMain} />
      )}
      {caption && !isMobile && (
        <Caption caption={caption} foodType={food_type} />
      )}
    </BannerCaptionWrapper>
  );
}
