import Link from "next/link";
import {
  Box,
  Text,
  Breadcrumb,
  BreadcrumbItem,
  BreadcrumbLink,
} from "@chakra-ui/react";
import { KtHeading } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";

import { AdditionalInfoWrapper } from "../_wrappers";

function BreadCrumb({ breadCrumbs, isSub = false }) {
  return (
    <Breadcrumb
      separator="-"
      color={isSub ? "black" : "white"}
      listProps={{
        flexDirection: "row",
        justifyContent: "center",
      }}
    >
      {breadCrumbs.map(({ _id, title, isCurrent, ...restProps }) => (
        <BreadcrumbItem key={_id} isCurrentPage={isCurrent}>


          {isCurrent ? (
            <BreadcrumbLink
              fontSize={appTextFontSize}
              _hover={{ textDecoration: "none" }}
            >
              {title}
            </BreadcrumbLink>
          ) : (
            <Link
              passHref
              legacyBehavior
              href={`/${restProps.link.parent.concat(
                restProps.link?.slug ? `/${restProps.link.slug}` : ""
              )}`}
            >              
                <BreadcrumbLink
                  fontSize={appTextFontSize}
                  _hover={{ textDecoration: "none" }}
                >
                  {title}
                </BreadcrumbLink>              
            </Link>
          )}

        </BreadcrumbItem>
      ))}
    </Breadcrumb>
  );
}

export default function AdditionalInfo({
  isSub,
  mediaQueryFallback,
  breadcrumb,
  heading,
  description,
}) {
  return (
    <AdditionalInfoWrapper isSub={isSub} fallback={mediaQueryFallback}>
      <BreadCrumb breadCrumbs={breadcrumb} isSub={isSub} />
      <KtHeading as="h2" color={isSub ? "black" : "white"}>
        {heading}
      </KtHeading>
      {description && (
        <Box
          maxW={{
            base: "full",
            md: "md",
          }}
          mx="auto"
          pt={4}
        >
          <Text color={isSub ? "black" : "white"}>{description}</Text>
        </Box>
      )}
    </AdditionalInfoWrapper>
  );
}
