import { bool, node } from "prop-types";
import { Box, Flex } from "@chakra-ui/react";
import { KtContainer } from "@/app/_components";

// Main Banner Wrapper Component
export function BannerWrapper({ isSub = false, desc = false, children }) {
  // Main Wrapper Style
  const bannerWrapperStyle = {
    pos: "relative",
    ...(isSub && {
      boxShadow: "inner",
      p: 6,
      bg: "aliceBlue.900"
    }),
  };

  return (
    <Box
      {...bannerWrapperStyle}
      sx={{
        "@media screen and (max-width: 767px)": {
          h: "auto",
        },
        "@media screen and (min-width: 766px)": {
          ...(isSub &&
            desc && {
              h: "30vh",
            }),
          ...(isSub &&
            !desc && {
              h: "20vh",
            }),
          ...(!isSub && {
            h: "100vh",
          }),
        },
      }}
    >
      {!isSub && (
        <Box
          as="span"
          pos="absolute"
          w="full"
          h="full"
          
        />
      )}
      {children}
    </Box>
  );
}

BannerWrapper.propTypes = {
  isSub: bool,
  desc: bool,
  children: node.isRequired,
};

// Article Banner Wrapper Component
export function ArticleBannerWrapper({ children }) {
  return <KtContainer pt={6} pos="relative">{children}</KtContainer>;
}

ArticleBannerWrapper.propTypes = {
  children: node.isRequired,
};

// BreadCrumb Wrapper Component
export function AdditionalInfoWrapper({ fallback, children, isSub = false }) {
  const additionalInfoWrapperStyle = {
    pos: {
      base: !isSub ? "absolute" : "relative",
      md: "absolute",
    },
    textAlign: "center",
    userSelect: "none",
  };

  return (
    <Box
      {...additionalInfoWrapperStyle}
      sx={{
        "@media screen and (max-width: 399px)": {
          ...(!isSub && {
            top: "39%",
          }),
          right: 0,
          left: 0,
          
        },
        "@media screen and (min-width: 400px)": {
          ...(!isSub && {
            top: "60%",
          }),
          ...(isSub && {
            top: "20%",
          }),
          right: 0,
          left: 0,
        },
"&:hover": {
      "& *": {
        color: "#FF9D00", // Target all child elements
      },
    },       
      }}
    >
      {children}
    </Box>
  );
}

AdditionalInfoWrapper.propTypes = {
  fallback: bool,
  isSub: bool,
  children: node.isRequired,
};

// Banner CaptionWrapper Component
export function BannerCaptionWrapper({ children }) {
  return (
    <Box
      w="full"
      pos="absolute"
      // bg="red.100"
      bottom="0"
      p={{
        base: 4,
        lg: 8,
      }}
    >
      <Flex
        direction={{
          base: "column",
          lg: "row",
        }}
        gap={{
          base: "3",
          lg: "4"
        }}  
        justifyContent={{
          base: "space-between",
          lg: "end",
        }}
        alignItems="center"
      >
        {children}
      </Flex>
    </Box>
  );
}

BannerCaptionWrapper.propTypes = {
  children: node.isRequired,
};
