import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import { BANNER_CATEGORIES } from "@/app/_constants/componentConstant";

import Banner from ".";

const { SUB_BANNER, ARTICLE_VIDEO_BANNER, MICRO_SITE_BANNER, VIDEO_BANNER } =
  BANNER_CATEGORIES;

export async function BannerLoader(props) {
  let reducedResults = props;

  const {
    block: { category },
  } = props;

  if (
    ![SUB_BANNER, ARTICLE_VIDEO_BANNER, MICRO_SITE_BANNER, VIDEO_BANNER].some(
      (c) => c === category
    )
  ) {
    const {
      image: {
        url: { mobile, desktop },
      },
    } = reducedResults;

    const base64BannerImageUrls = {};

    // Generating Desktop Blur Image Url
    await getBase64ImageUrl(desktop).then((result) => {
      base64BannerImageUrls.desktop = result;
    });

    // Generating Mobile Blur Image Url
    await getBase64ImageUrl(mobile).then((result) => {
      base64BannerImageUrls.mobile = result;
    });

    reducedResults = {
      ...reducedResults,
      image: {
        ...reducedResults.image,
        base64: base64BannerImageUrls,
      },
    };

    // Checking the gallery is exists, then generating blur placeholders
    if (props.hasOwnProperty("gallery")) {
      for await (const _g of Object.keys(props.gallery)) {
        await Promise.all(
          props.gallery[_g].map(async (_i) => {
            const { url } = _i.image;
            const base64ImageUrl = await getBase64ImageUrl(url);
            return {
              ..._i,
              image: {
                ..._i.image,
                base64: base64ImageUrl,
              },
            };
          })
        ).then((result) => {
          reducedResults.gallery[_g] = result;
        });
      }
    }
  }

  return <Banner {...reducedResults} />;
}
