"use client";

import { Box, Flex, Grid, GridItem } from "@chakra-ui/react";
import { KtContainer, AppSection } from "@/app/_components";
import { isObjectEmpty } from "@/app/_utils";

import {
  AccomodationInfo,
  ArticleHeading,
  ArticleMarkDown,
  AuthorDetails,
  AtmosphereInfo,
  ContactInfo,
  EventDuration,
  Facilities,
  FindAmazing,
  GeographicalInfo,
  HowToReach,
  InfoBox,
  InfoCard,
  ItineraryList,
  Location,
  PublishTrip,
  Ebrochure,
  Rating,
  WhereToBuy
} from "./components"

export default function Article({
  _id,
  article: { heading, content,disclaimer, ...restProps },
  related_info = {},
}) {
  return (
    <AppSection id={_id}>
      <KtContainer>
        <Grid
          templateColumns={{
            base: "100%",
            lg: !isObjectEmpty(related_info) ? "68% 28%" : "68%",
          }}
          {...(isObjectEmpty(related_info) && {
            placeContent: {
              base: "normal",
              lg: "center",
            },
          })}
          autoFlow={{
            base: "row",
          }}
          gap={{
            base: 0,
            lg: "4%",
          }}
        >
          <GridItem>
            <Box
              flex={{
                base: "0 0 100%",
                lg: 1,
              }}
            >
              {/* Article Heading And Sharing Section  */}
              {heading && (
                <ArticleHeading
                  heading={heading}
                  published_at={restProps?.published_at ?? ""}
                />
              )}

              {/* Mardown Component */}
              <ArticleMarkDown content={content} disclaimer={disclaimer} />

              {/* Facilities Component */}
              {restProps?.facilities && (
                <Facilities facilities={restProps.facilities} />
              )}

              {/* Article How To Reach Section */}
              {restProps?.how_to_reach && (
                <HowToReach how_to_reach={restProps.how_to_reach} />
              )}

              {/* Showing Find Amazing Info  */}
              {restProps?.find_amazing && (
                <FindAmazing {...restProps.find_amazing} />
              )}

              {/* Article Packages Included */}
              {restProps?.package_included && (
                <InfoBox {...restProps.package_included} />
              )}

              {/* Article Experiences in packages */}
              {restProps?.experiences_offered && (
                <InfoBox {...restProps.experiences_offered} pt={8} />
              )}

              {/* Article Itineraries List */}
              {restProps?.itineraries && (
                <ItineraryList {...restProps.itineraries} />
              )}

              {/* Article Package Inclusions */}
              {restProps?.inclusions && (
                <InfoBox {...restProps.inclusions} pt={8} />
              )}

              {/* Article Package Exclusions */}
              {restProps?.exclusions && (
                <InfoBox {...restProps.exclusions} pt={8} />
              )}
            </Box>
          </GridItem>
          {related_info && (
            <GridItem>
              <Flex
                w="full"
                direction="column"
                gap={8}
                {...((related_info?.duration ||
                  related_info?.atmosphere ||
                  related_info?.accomodation_info ||
                  related_info?.author_details) && {
                  justify: "space-evenly",
                })}
              >
                {/* Event Duration */}
                {related_info?.duration && (
                  <EventDuration {...related_info.duration} />
                )}

                {/* Atmosphere Information */}
                {/* {related_info?.atmosphere && (
                  <AtmosphereInfo {...related_info.atmosphere} />
                )} */}

                {/* Package Category Info */}
                {related_info?.package_category && (
                  <InfoCard {...related_info.package_category} />
                )}

                {/* Stories Related Information */}
                {related_info?.author_details && (
                  <>
                    <AuthorDetails {...related_info.author_details} />
                   {/*  <PublishTrip /> */}
                  </>
                )}

                {/* Accomodation Information */}
                {related_info?.accomodation_info && (
                  <AccomodationInfo {...related_info.accomodation_info} />
                )}

                {/* Geographical Information */}
                {related_info?.geographical_info && (
                  <GeographicalInfo {...related_info.geographical_info} />
                )}

                {/* Contact Information */}
                {related_info?.contact_info && (
                  <ContactInfo
                    contact_info={related_info.contact_info}
                    pt={
                      !related_info?.duration && !related_info?.atmosphere
                        ? 0
                        : 0
                    }
                  />
                )}

                {/* Package Info Information */}
                {related_info?.package_info && (
                  <InfoCard {...related_info.package_info} />
                )}

                {/* Accomodation Rating */}
                {related_info?.rating && (
                  <Rating rating={related_info.rating} />
                )}

                {/* Location Information */}
                {related_info?.location && (
                  <Location {...related_info.location} />
                )}
                
                {/* Erochure Information */}
                {related_info?.ebrochure && (
                  <Ebrochure {...related_info.ebrochure} />
                )}
              </Flex>
            </GridItem>
          )}
        </Grid>
        {/* Showing Where To Buy Info */}
        {restProps?.where_to_buy && (
          <WhereToBuy items={restProps.where_to_buy.items} />
        )}
      </KtContainer>
    </AppSection>
  );
}
