import { Flex, Box, Text } from "@chakra-ui/react";
import { AppLink, KtHeading } from "@/app/_components";
import { isObjectEmpty } from "@/app/_utils";

export function InfoBox({
  heading,
  description,
  link = {},
  ...restStyleProps
}) {
  return (
    <Flex direction="column" gap={3} {...restStyleProps}>
      <KtHeading as="h6">{heading}</KtHeading>
      <Text as="p">{description}</Text>
      {!isObjectEmpty(link) && (
        <Box display="inline-flex" pt={5} pb={{ base: 4, lg: 0 }}>
          <AppLink
            type={link.type}
            parent={link.parent}
            slug={link.slug}
            title={link.title}
            color="black"
            variant="pill"
            arrow
          >
            {link.text}
          </AppLink>
        </Box>
      )}
    </Flex>
  );
}

export function InfoCard({ label, info, link = {} }) {
  return (
    <Box boxShadow="lg" p="6" rounded="md" bg="white">
      <Flex direction="column" gap={4}>
        <Text fontSize="24px">{label}</Text>
        <Box maxW={56}>
          <KtHeading as="h6" color="sage.900">
            {info}
          </KtHeading>
        </Box>

        {!isObjectEmpty(link) && (
          <Box display="inline-flex" pt={5} pb={{ base: 4, lg: 0 }}>
            <AppLink
              type={link.type}
              parent={link.parent}
              slug={link.slug}
              title={link.title}
              color="black"
              variant="pill"
              arrow
            >
              {link.text}
            </AppLink>
          </Box>
        )}
      </Flex>
    </Box>
  );
}
