import { Grid, Box } from "@chakra-ui/react";
import { KtHeading } from "@/app/_components";

import InfoCard from "@/app/_components/AppCard/InfoCard";

export default function WhereToBuy({ items }) {
  return (
    <Box pt={{ base: 12, lg: 0 }}>
      <KtHeading as="h6" pb={5}>
        You can buy this from
      </KtHeading>
      <Grid
        templateColumns="repeat(auto-fit, minmax(300px, 1fr))"
        gap={5}
      >
        {items.map(({ _id, ...rest }) => (
          <InfoCard {...rest} key={_id} />
        ))}
      </Grid>
    </Box>
  );
}
