import dynamic from "next/dynamic";

import { Flex, Card, Text, IconButton } from "@chakra-ui/react";
import { BsPencil } from "react-icons/bs";

const StartRating = dynamic(
  () => import("@/app/_components").then((mod) => mod.Rating),
  { ssr: false }
);

export default function Rating({ rating }) {
  return (
    <Card direction="column" px={6} py={6} h={44}>
      <StartRating rating={rating} starDimension="35px" starSpacing="5px" />
      <Text as="span" color="black" pt={2}>
        {rating} Ratings
      </Text>
      <Flex
        align="center"
        gap={10}
        pt={5}
        sx={{
          svg: {
            fill: "orangePeel.900",
          },
        }}
      >
        <IconButton icon={<BsPencil />} size="lg" />
        <Text as="span">Write a Review</Text>
      </Flex>
    </Card>
  );
}
