import { Flex, Text, Button } from "@chakra-ui/react";
import { BsPlus } from "react-icons/bs";
import { KtHeading } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";

export default function PublishTrip() {
  return (
    <Flex
      justify="center"
      direction="column"
      boxShadow="lg"
      p={8}
      rounded="md"
      bg="white"
      gap={6}
      minH={40}
    >
      <KtHeading as="h6" color="black">
        Share your <br /> Kerala experience
      </KtHeading>
      <Text as="p" fontSize={appTextFontSize}>
        Had a trip of your lifetime in Kerala? Share <br /> your story with us
        and get featured here.
      </Text>
      <Button
        size="md"
        variant="outline"
        width="200px"
        borderRadius="full"
        borderColor="black"
        transition=".5s linear"
        _hover={{
          borderColor: "orangePeel.900",
          "& svg": {
            fontSize: "40",
            "> path": {
              fill: "orangePeel.900",
            },
          },
        }}
        rightIcon={<BsPlus fontSize={30} />}
        fontSize={appTextFontSize}
      >
        Publish your trip
      </Button>
    </Flex>
  );
}
