import { number } from "prop-types";
import { ReactSVG } from "react-svg";

import { Text, Box, Flex, Card, IconButton } from "@chakra-ui/react";
import { KtHeading, AppImage } from "@/app/_components";
import { BsSend } from "react-icons/bs";
import Link from "next/link";

export default function Location({ lat, long }) {
  const gmapUrl = `https://www.google.com/maps/?q=${lat},${long}`;
  return (
    <>
    <Card p="6">
      <Flex
        gap={{ base: 4, md: 0 }}
        borderTop={{ base: "1px solid #dae1c5", lg: "none" }}
        pt={{ base: "15px", lg: 0 }}
      >
        <Box
          maxW={{
            base: "full",
            md: "36",
          }}
          display="flex"
          gap={2}
          flexDirection="column"
          justifyContent={{
            base: "space-between",
            md: "center",
            lg: "space-between",
          }}
        >
          <KtHeading as="h6" color="sage.900">
          <Link target="_blank" href={gmapUrl}> View On Map</Link>
          </KtHeading>
          <Link target="_blank" href={gmapUrl}>
          <Box
            display="inline-flex"
            sx={{
              "svg path": {
                fill: "orangePeel.900",
              },
            }}
          >
            <IconButton alt="Click to view on Map" title="Click to view on Map" size="lg" icon={<BsSend />} />
            
          </Box>
          </Link>
        </Box>
        <Box>
        <Link target="_blank" href={gmapUrl}><ReactSVG alt="Click to view on Map" title="Click to view on Map" src="/icons/maps.svg" /></Link>
        </Box>
      </Flex>
    </Card>
    <Card p="6">
    <KtHeading as="h6" color="sage.900" mb={4}>
      Emergency Numbers
    </KtHeading>
    <Flex
      gap={{ base: 4, md: 0 }}
      borderTop={{ base: "1px solid #dae1c5", lg: "none" }}
      pt={{ base: "15px", lg: 0 }}
      direction={{ base: "column", md: "row" }} // Adjust direction for responsive design
    >
      <Flex direction="column" flex={1}>
        <Box mb={2}>
          <Text color="#4D4D4D" fontSize="16px">
            Police Control Room: 100, 112
          </Text>
        </Box>
        <Box mb={2}>
          <Text color="#4D4D4D" fontSize="16px">
            Fire Station: 101
          </Text>
        </Box>
        <Box>
          <Text color="#4D4D4D" fontSize="16px">
            Ambulance: 102, 108
          </Text>
        </Box>
      </Flex>
    </Flex>
  </Card>
  { /* 
  <Card p="6">
    <KtHeading as="h6" color="sage.900" mb={4}>
      Ebrochures
    </KtHeading>
    <Flex
      gap={{ base: 4, md: 0 }}
      borderTop={{ base: "1px solid #dae1c5", lg: "none" }}
      pt={{ base: "15px", lg: 0 }}
      direction={{ base: "column", md: "row" }} // Adjust direction for responsive design
    >
        <AppImage
          src='http://202.88.244.195:3000/_next/image/?url=http%3A%2F%2F202.88.244.195%3A81%2Fkt2023%2Fimg%2Fpages%2Fmobile%2Fmunnar-mesmerisingly-yours-1715778818_f76bdf427724e34da86d.webp&w=828&q=75'
          alt='test'
          title='test'
          width={1280}
          height={720}
          style={{ width: "100%" }}
        />      
    </Flex>
  </Card>  
  */}
  </>
  );
}

Location.propTypes = {
  lat: number.isRequired,
  long: number.isRequired,
};
