import { Card, CardBody, Flex, Text } from "@chakra-ui/react";
import { KtHeading } from "@/app/_components"

export default function GeographicalInfo({ altitude, area, population }) {
  return (
    <Card>
      <CardBody gap={5} display="flex" flexDirection="column">
        <KtHeading as="h6" color="sage.900">
          Geographical <br />
          Information
        </KtHeading>
        <Flex direction="column" gap={2} fontWeight="medium">
          <Text as="p">Altitude : {altitude}</Text>
          <Text as="p">Area : {area}</Text>
          <Text as="p">Population : {population}</Text>
        </Flex>
      </CardBody>
    </Card>
  );
}
