import { Flex, Box, Heading, Text } from "@chakra-ui/react";
import { AppLink } from "@/app/_components";

export default function FindAmazing({
  description,
  link: { text, ...restLinkProps },
}) {
  return (
    <Flex direction="column" gap={3} maxW="3xl">
      <Heading as="h6" fontSize="30px" color="black">
        Find Amazing
      </Heading>
      <Text as="p">{description}</Text>
      <Box display="inline-flex" pt={5} pb={{ base: 4, lg: 0 }}>
        <AppLink {...restLinkProps} variant="pill" color="black" arrow>
          {text}
        </AppLink>
      </Box>
    </Flex>
  );
}
