import { ReactSVG } from "react-svg";
import { Box, Flex, Grid, Heading, Text } from "@chakra-ui/react";

const facilitiesInfo = {
  wifi: {
    label: "Wifi",
    icon_url: "/icons/wifi.svg",
  },
  fitness_center: {
    label: "Fitness Center",
    icon_url: "/icons/fitness_center.svg",
  },
  parking: {
    label: "Parking",
    icon_url: "/icons/parking.svg",
  },
  swimming_pool: {
    label: "Swimming Pool",
    icon_url: "/icons/swimming_pool.svg",
  },
  restaurant: {
    label: "Restaurant",
    icon_url: "/icons/restaurant.svg",
  },
  television: {
    label: "Television",
    icon_url: "/icons/television.svg",
  },
  room_service: {
    label: "Room Service",
    icon_url: "/icons/room_service.svg",
  },
  house_keeping: {
    label: "House Keeping",
    icon_url: "/icons/house_keeping.svg",
  },
  break_fast: {
    label: "Breakfast",
    icon_url: "/icons/breakfast.svg",
  },
  laundary: {
    label: "Laundary",
    icon_url: "/icons/laundary.svg",
  },
  spa: {
    label: "Spa",
    icon_url: "/icons/spa.svg",
  },
  air_conditioning: {
    label: "Air Conditioning",
    icon_url: "/icons/air_conditioning.svg",
  },
};

export default function Facilities({ facilities }) {
  return (
    <Box pt={5} pb={5}>
      <Heading as="h6" fontSize="30px" color="black">
        Facilities
      </Heading>
      <Grid templateColumns={{
        base: "repeat(2, 1fr)",
        sm: "repeat(3, 1fr)",
        md: "repeat(3, 1fr)"
      }} gap={2} mt={5} mb={10}>
        {Object.keys(facilitiesInfo).map((item) => (
          <Flex key={item} p={3} align="center" gap={5}>
            <ReactSVG src={facilitiesInfo[item].icon_url} />
            <Text as={facilities[item] ? "span" : "s"}>
              {facilitiesInfo[item].label}
            </Text>
          </Flex>
        ))}
      </Grid>
    </Box>
  );
}
