import { string } from "prop-types";
import { ReactSVG } from "react-svg";

import { Box, Card, Heading, Text, Flex, Divider } from "@chakra-ui/react";
import { months } from "@/app/_utils";

const DateViewer = ({ date }) => {
  return (
    <Box display="flex" flexDirection="column">
      <Heading as="h4" color="orangePeel.900">
        {new Date(date).getDate().toString().padStart(2, 0)}
      </Heading>
      <Text as="span">{months[new Date(date).getMonth()]}</Text>
      <Text as="span">{new Date(date).getFullYear()}</Text>
    </Box>
  );
};

export default function EventDuration({ startDate, endDate }) {
  return (
    <Card direction="row" align="center" justify="center" p="5" gap={10} h={40}>
      <Flex h="full" align="center" gap={2}>
        <ReactSVG src="/icons/calendar.svg" />
      </Flex>
      <Divider orientation="vertical" h="80px" />
      <Flex align="center" gap={5}>
        <DateViewer date={startDate} />
        {startDate!=endDate}
        {startDate !== endDate ? (
            <>
              <Box as="span">-</Box>
              <DateViewer date={endDate} />
            </>
          ) : null}
        {/* <Box as="span">-</Box>
        <DateViewer date={endDate} /> */}
      </Flex>
    </Card>
  );
}

EventDuration.propTypes = {
  startDate: string.isRequired,
  endDate: string.isRequired,
};
