import { number } from "prop-types";
import { ReactSVG } from "react-svg";

import { Text, Box, Flex, Card, IconButton } from "@chakra-ui/react";
import { KtHeading, AppImage } from "@/app/_components";
import { BsSend } from "react-icons/bs";
import Link from "next/link";

export default function Ebrochure({ heading, image={alt,url},link }) {
  let prnt, trg, ur;
  if (link) {
    if (link.type === "internal" || link.type === "link") {
      prnt = process.env.NEXT_PUBLIC_APP_BASE_URL + link.parent;
    } else if (link.type === "internal-other") {
      prnt = process.env.NEXT_PUBLIC_OLD_URL + link.parent;
    } else {
      prnt = link.parent;
    }
    ur = (prnt ?? "").concat(link.slug ?? "");
    trg = (link.type !== "internal-other" && link.type !== "external") ? "" : "_blank";
  }

  return (
    <>
    <Link href={ur} title={heading} target={trg}>
    <Card p="6">
  <KtHeading as="h6" color="sage.900" mb={4}>
  E-Brochure

  </KtHeading>
  <Flex
    gap={4} // Adjust the gap as needed for spacing
    borderTop={{ base: "1px solid #dae1c5", lg: "none" }}
    pt={{ base: "15px", lg: 0 }}
    direction="column" // Set to column to stack items vertically
    align="center" // Optional: Center align the content
  >
    <AppImage
      src={image.url}
      alt={image.alt}
      title={heading}
      width={500}
      height={500}
      style={{ width: "100%" }}
    />
    <KtHeading as="h6" color="black" mt={4}> {/* Add margin-top for spacing */}
      {heading}
    </KtHeading>
  </Flex>
</Card>
</Link>
  </>
  );
}


