import { shape, string } from "prop-types";
import { ReactSVG } from "react-svg";
import {
  Box,
  Text,
  Alert,
  AlertIcon,
  Accordion,
  AccordionItem,
  AccordionButton,
  AccordionIcon,
  AccordionPanel,
  Flex,
} from "@chakra-ui/react";
import {
  BsBoxArrowUpRight,
  BsEnvelope,
  BsPhone,
  BsGeoAlt,
  BsTelephone,
} from "react-icons/bs";

import { AppLink } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import React from 'react';
import { Fragment } from "react";
import Link from "next/link";

const getIconUrl = (icon_type) => {
  let iconUrl;
  switch (icon_type) {
    case "venue":
      iconUrl = "/icons/venue.svg";
      break;
    case "contact":
      iconUrl = "/icons/contact.svg";
      break;
    case "timing":
      iconUrl = "/icons/timer.svg";
      break;
    case "booking":
      iconUrl = "/icons/ticket.svg";
      break;
    case "material":
      iconUrl = "/icons/material.svg";
      break;
    case "category":
      iconUrl = "/icons/category.svg";
      break;
    case "cooking_time":
      iconUrl = "/icons/cooking_time.svg";
      break;
    case "type":
      iconUrl = "/icons/cooking_type.svg";
      break;
    default:
      iconUrl = "/icons/ticket.svg";
      break;
  }
  return iconUrl;
};

export default function ContatInfo({ contact_info, pt }) {
  return (
    <Box pt={pt}>
      <Accordion allowToggle>
        {Object.keys(contact_info).map((ci) => (
          <AccordionItem key={ci} border="none">
            <Text as="h5">
              <AccordionButton p={5} _hover={{ bg: "white" }}>
                <Box
                  as="span"
                  display="flex"
                  gap="20px"
                  alignItems="center"
                  flex="1"
                  textAlign="left"
                  fontSize={appTextFontSize}
                >
                  <ReactSVG src={getIconUrl(ci)} />
                  {contact_info[ci]["label"]}
                </Box>
                <AccordionIcon />
              </AccordionButton>
            </Text>
            <AccordionPanel pb={4} bg="aliceBlue.900" borderRadius="md">
              {contact_info[ci]?.info ? (
                <Flex px={2} py={5} gap={5} direction="column">
                  {contact_info[ci].info?.description && (
                    <Text as="p" fontSize={appTextFontSize}>
                      {contact_info[ci].info?.description}
                    </Text>
                  )}
                  {(contact_info[ci].info?.booking_url ||
                    contact_info[ci].info?.availability_url) && (
                    <Flex justify="space-between" align="center">
                      {contact_info[ci].info?.booking_url && (
                        <Box display="inline-flex">
                          <AppLink
                            type="external"
                            variant="pill"
                            color="black"
                            parent={contact_info[ci].info.booking_url}
                            arrow
                          >
                            Book Now
                          </AppLink>
                        </Box>
                      )}
                      {contact_info[ci].info?.availability_url && (
                        <Box
                          display="inline-flex"
                          sx={{
                            a: {
                              border: "none",
                              color: "#838383",
                              fontWeight: "semibold",
                            },
                          }}
                        >
                          <AppLink
                            type="external"
                            variant="pill"
                            color="black"
                            parent={contact_info[ci].info?.availability_url}
                            arrow
                          >
                            Availability
                          </AppLink>
                        </Box>
                      )}
                    </Flex>
                  )}
                  {/* {contact_info[ci].info?.time_range && (
                    <Text as="p" fontWeight="medium" fontSize={appTextFontSize}>
                      {contact_info[ci].info?.time_range}
                    </Text>
                  )} */}
                  {/* {contact_info[ci].info?.time_range && (
                    <Text as="p" fontWeight="medium" fontSize={appTextFontSize}>
                      {Array.isArray(contact_info[ci].info.time_range)
                        ? contact_info[ci].info.time_range.join("<br/> ") // Assuming you want to join array elements with a comma
                        : contact_info[ci].info.time_range}
                    </Text>
                  )} */}
                  {/* {contact_info[ci].info?.time_range && (
                    <Text as="p" fontWeight="medium" fontSize={appTextFontSize}>
                      {Array.isArray(contact_info[ci].info.time_range)
                        ? contact_info[ci].info.time_range
                            .map((item) => {
                              if (typeof item === "object" && item !== null) {
                                // Display properties of the object
                                return Object.values(item).join(" ");
                              } else {
                                return item;
                              }
                            })
                            .join("\n\n")
                        : contact_info[ci].info.time_range}
                    </Text>
                  )} */}

                  {/* {contact_info[ci].info?.time_range && (
                    <Text as="p" fontWeight="medium" fontSize={appTextFontSize}>
                      {Array.isArray(contact_info[ci].info.time_range)
                        ? contact_info[ci].info.time_range.map(
                            (item, index) => {
                              if (typeof item === "object" && item !== null) {
                                // Display properties of the object on individual lines
                                return (
                                  <Fragment key={index}>
                                    {Object.entries(item).map(
                                      ([key, value], innerIndex) => (
                                        <div key={innerIndex}>
                                          {key.charAt(0).toUpperCase() + key.slice(1)}{` `}: {` `}{value}
                                        </div>
                                      )
                                    )}
                                  </Fragment>
                                );
                              } else {
                                return <div key={index}>{item}</div>;
                              }
                            }
                          )
                        : contact_info[ci].info.time_range}
                    </Text>
                  )} */}

                  <Text as="p" fontWeight="medium" fontSize={appTextFontSize}>
                    {Array.isArray(contact_info[ci].info.time_range)
                      ? contact_info[ci].info.time_range
                          .map((item) => {
                            if (typeof item === "object" && item !== null) {
                              // Extract days and time from the object
                              const { days, time } = item;
                              // Replace the last comma in days with "and"
                              const formattedDays = days.replace(
                                /,([^,]*)$/,
                                " and$1"
                              );
                              // Format the output string
                              return `${time} on ${formattedDays}`;
                            } else {
                              return item;
                            }
                          })
                          .join("\n\n")
                      : contact_info[ci].info.time_range}
                  </Text>

                  {ci === "contact" &&
                    Object.keys(contact_info[ci]?.info)?.map((i) => (
                      <Flex
                        key={i}
                        gap={4}
                        sx={{
                          svg: {
                            fill: "orangePeel.900",
                            marginTop: "1.5%",
                          },
                        }}
                        wordBreak="break-word"
                      >
                        {i === "g_website_url" && <BsBoxArrowUpRight />}
                        {i === "f_email" && <BsEnvelope />}
                        {i === "contact_no" && <BsPhone />}
                        {i === "address" && <BsGeoAlt />}
                        {i === "d_telephone" && <BsTelephone />}
                        {i === "e_fax" && <BsTelephone />}

                        {contact_info[ci].info[i] instanceof Array ? (
                          <Flex direction="column">
                            {contact_info[ci].info[i].map((c) => (
                              <Text
                                as="span"
                                fontSize={appTextFontSize}
                                key={c}
                                color="#4D4D4D"
                              >
                                {c}
                              </Text>
                            ))}
                          </Flex>
                        ) : (
                          <Text
                            as="span"
                            color="#4D4D4D"
                            fontSize={appTextFontSize}
                          >
                            {i === "f_email" ? (
                              contact_info[ci].info[i]
                                .split(",")
                                .map((email, index) => (
                                  <Link href={`mailto:${email}`} key={index}>
                                    {email}
                                  </Link>
                                ))
                            ) : i === "contact_no" || i === "d_telephone" ? (
                              contact_info[ci].info[i]
                                .split(",")
                                .map((number, index) => (
                                  <React.Fragment key={index}>
                                    <Link href={`tel:${number}`}>{number}</Link>
                                    {index !== contact_info[ci].info[i].split(",").length - 1 && ", "}
                                  </React.Fragment>
                                ))
                            ) : i === "g_website_url" ? ( // Check if i is "g_website_url"
                              <Link
                                href={contact_info[ci].info[i]}
                                target="_blank"
                              >
                                {contact_info[ci].info[i]}
                              </Link>
                            ) : (
                              contact_info[ci].info[i]
                            )}
                          </Text>
                        )}
                      </Flex>
                    ))}
                </Flex>
              ) : (
                <Alert status="error">
                  <AlertIcon />
                  No Design Provided
                </Alert>
              )}
            </AccordionPanel>
          </AccordionItem>
        ))}
      </Accordion>
    </Box>
  );
}

ContatInfo.propTypes = {
  contact_info: shape({
    booking: shape({
      label: string,
    }),
    venue: shape({
      label: string,
    }),
    timing: shape({
      label: string,
    }),
    booking: shape({
      label: string,
    }),
  }),
};
