import { Flex, Avatar, Text } from "@chakra-ui/react";

export default function AuthorDetails({
  author_name,
  avatar_url,
  designation,
  author_email,
}) {
  return (
    <Flex
      align="center"
      justify="center"
      direction="column"
      boxShadow="lg"
      py={8}
      rounded="md"
      bg="white"
      gap={2}
      h="50%"
    >
      {/* <Avatar src={avatar_url} size="2xl" /> */}
      <Text fontWeight="semibold" textAlign="center" fontSize="22">
        {author_name}
      </Text>
      <Text as="span" fontWeight="semibold" fontSize="18">
        {designation}
      </Text>
      <Text as="span" fontWeight="semibold" fontSize="18">
        {author_email}
      </Text>
    </Flex>
  );
}
