import { string } from "prop-types";

import { ReactSVG } from "react-svg";
import { Flex, Box, Text,Image } from "@chakra-ui/react";
import { appTextFontSize } from "@/app/_components/_styles";

export default function AtmosphereInfo({ perception, climate, icon_url }) {
  return (
    <Flex
      gap={10}
      sx={{
        svg: {
          width: {
            sm: "150px",
          },
          height: {
            sm: "150px",
          },
        },
      }}
    >
      {/* <ReactSVG src="/icons/weather.svg" /> */}
      <Image src={icon_url} width={140} height={140} alt={climate} title={climate} />
      <Box display="flex" justifyContent="center" flexDirection="column" gap={1}>
        <Text
          as="span"
          fontSize={{
            base: 50,
          }}
          lineHeight={1}
        >
          {perception}&#8451;
        </Text>
        <Text as="span" fontSize={appTextFontSize}>
          {climate}
        </Text>
      </Box>
    </Flex>
  );
}

AtmosphereInfo.propTypes = {
  perception: string.isRequired,
  climate: string.isRequired,
  icon_url: string.isRequired,
};
